/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

@Resource(name="Mapping")
public class MappingTypeConverterFactory
implements TypeConverterFactory<String, String>,
Configurable {
    private Properties properties = new Properties();

    public MappingTypeConverter createTypeConverter() {
        MappingTypeConverter mappingTypeConverter = new MappingTypeConverter();
        mappingTypeConverter.setConfiguration(this.properties);
        return mappingTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<String>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<String>>(String.class, String.class, (short)0);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public static class MappingTypeConverter
    implements TypeConverter<String, String>,
    Configurable {
        private Properties properties;
        private boolean strict;

        public void setConfiguration(Properties properties) throws SmooksConfigException {
            this.properties = properties;
            this.strict = properties.getProperty("strict", "true").equals("true");
        }

        public Properties getConfiguration() {
            return this.properties;
        }

        public String convert(String value) {
            if (value != null) {
                String mappingValue = this.properties.getProperty(value);
                if (mappingValue == null) {
                    if (this.strict) {
                        throw new TypeConverterException("Mapping <param> for data '" + value + "' not defined.");
                    }
                    return value;
                }
                return mappingValue;
            }
            return null;
        }
    }
}

