/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.bean.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.smooks.api.ExecutionContext;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.engine.bean.context.StandaloneBeanContext;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.source.JavaSource;

public class StandaloneBeanContextFactory {
    public static StandaloneBeanContext create(ExecutionContext executionContext) {
        BeanIdStore beanIdStore = executionContext.getApplicationContext().getBeanIdStore();
        Map<String, Object> beanMap = StandaloneBeanContextFactory.createBeanMap(executionContext, beanIdStore);
        StandaloneBeanContext beanContext = new StandaloneBeanContext(executionContext, beanIdStore, beanMap);
        return beanContext;
    }

    private static Map<String, Object> createBeanMap(ExecutionContext executionContext, BeanIdStore beanIdStore) {
        JavaSource javaSource;
        Map<String, Object> sourceBeans;
        Optional<Sink> sink = ((List)executionContext.getOrDefault(Sink.SINKS_TYPED_KEY, Collections.emptyList())).stream().filter(s -> JavaSink.class.isAssignableFrom(s.getClass())).findFirst();
        Source source = (Source)executionContext.get(Source.SOURCE_TYPED_KEY);
        Map<String, Object> beanMap = null;
        if (sink.isPresent()) {
            JavaSink javaSink = (JavaSink)sink.get();
            beanMap = javaSink.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (beanIdStore.containsBeanId(beanId)) continue;
                beanIdStore.register(beanId);
            }
        }
        return beanMap;
    }
}

