/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class AttachKey<T> {
    public static final int MAX_ATTACHE_COUNT = 128;
    private static final ConcurrentMap<String, AttachKey> NAMES = new ConcurrentHashMap<String, AttachKey>();
    private static final AtomicInteger INDEX_BUILDER = new AtomicInteger(0);
    private final String key;
    private final int index;

    private AttachKey(String key) {
        this.key = key;
        this.index = INDEX_BUILDER.getAndIncrement();
        if (this.index < 0 || this.index >= 128) {
            throw new RuntimeException("too many attach key");
        }
    }

    public static <T> AttachKey<T> valueOf(String name) {
        AttachKey<T> old;
        AttachKey<T> option = (AttachKey<T>)NAMES.get(name);
        if (option == null && (old = NAMES.putIfAbsent(name, option = new AttachKey<T>(name))) != null) {
            option = old;
        }
        return option;
    }

    public String getKey() {
        return this.key;
    }

    int getIndex() {
        return this.index;
    }
}

