/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.UdpAioSession;

class UdpDispatcher
implements Runnable {
    public static final RequestTask EXECUTE_TASK_OR_SHUTDOWN = new RequestTask(null, null);
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpDispatcher.class);
    private final BlockingQueue<RequestTask> taskQueue = new LinkedBlockingQueue<RequestTask>();
    private final MessageProcessor processor;

    public UdpDispatcher(MessageProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void run() {
        block3: while (true) {
            try {
                while (true) {
                    RequestTask unit;
                    if ((unit = this.taskQueue.take()) == EXECUTE_TASK_OR_SHUTDOWN) {
                        LOGGER.info("shutdown thread:{}", (Object)Thread.currentThread());
                        break block3;
                    }
                    this.processor.process((AioSession)unit.session, unit.request);
                    unit.session.writeBuffer().flush();
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("InterruptedException", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getClass().getName(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void dispatch(UdpAioSession session, Object request) {
        this.dispatch(new RequestTask(session, request));
    }

    public void dispatch(RequestTask requestTask) {
        this.taskQueue.offer(requestTask);
    }

    static class RequestTask {
        UdpAioSession session;
        Object request;

        public RequestTask(UdpAioSession session, Object request) {
            this.session = session;
            this.request = request;
        }
    }
}

