/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.UdpAioSession;
import org.smartboot.socket.transport.UdpBootstrap;
import org.smartboot.socket.transport.WriteBuffer;

public final class UdpChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpChannel.class);
    private final BufferPage bufferPage;
    private final ConcurrentHashMap<SocketAddress, UdpAioSession> sessionMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<ResponseUnit> responseTasks;
    private final Semaphore writeSemaphore = new Semaphore(1);
    private final UdpBootstrap.Worker worker;
    IoServerConfig config;
    private DatagramChannel channel;
    private SelectionKey selectionKey;
    private ResponseUnit failResponseUnit;

    UdpChannel(DatagramChannel channel, UdpBootstrap.Worker worker, IoServerConfig config, BufferPage bufferPage) {
        this.channel = channel;
        this.responseTasks = new ConcurrentLinkedQueue();
        this.worker = worker;
        this.bufferPage = bufferPage;
        this.config = config;
    }

    private void write(VirtualBuffer virtualBuffer, SocketAddress remote) throws IOException {
        if (this.writeSemaphore.tryAcquire() && this.responseTasks.isEmpty() && this.send(virtualBuffer.buffer(), remote) > 0) {
            virtualBuffer.clean();
            this.writeSemaphore.release();
            return;
        }
        this.responseTasks.offer(new ResponseUnit(remote, virtualBuffer));
        if (this.selectionKey == null) {
            this.worker.addRegister(selector -> this.selectionKey.interestOps(this.selectionKey.interestOps() | 4));
        } else if ((this.selectionKey.interestOps() & 4) == 0) {
            this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
        }
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    void doWrite() throws IOException {
        ResponseUnit responseUnit;
        while (true) {
            if (this.failResponseUnit == null) {
                responseUnit = this.responseTasks.poll();
                LOGGER.info("poll from writeBuffer");
            } else {
                responseUnit = this.failResponseUnit;
                this.failResponseUnit = null;
            }
            if (responseUnit == null) {
                this.writeSemaphore.release();
                if (this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                    if (!this.responseTasks.isEmpty()) {
                        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                    }
                }
                return;
            }
            if (this.send(responseUnit.response.buffer(), responseUnit.remote) <= 0) break;
            responseUnit.response.clean();
        }
        this.failResponseUnit = responseUnit;
    }

    private int send(ByteBuffer byteBuffer, SocketAddress remote) throws IOException {
        AioSession aioSession = this.sessionMap.get(remote);
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().beforeWrite(aioSession);
        }
        int size = this.channel.send(byteBuffer, remote);
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().afterWrite(aioSession, size);
        }
        return size;
    }

    public AioSession connect(SocketAddress remote) {
        return this.createAndCacheSession(remote);
    }

    public AioSession connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    UdpAioSession createAndCacheSession(SocketAddress remote) {
        return this.sessionMap.computeIfAbsent(remote, s -> {
            Consumer<WriteBuffer> consumer = writeBuffer -> {
                VirtualBuffer virtualBuffer = writeBuffer.poll();
                if (virtualBuffer == null) {
                    return;
                }
                try {
                    this.write(virtualBuffer, remote);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            WriteBuffer writeBuffer2 = new WriteBuffer(this.bufferPage, consumer, this.config.getWriteBufferSize(), 1);
            return new UdpAioSession(this, remote, writeBuffer2);
        });
    }

    void removeSession(SocketAddress remote) {
        UdpAioSession udpAioSession = this.sessionMap.remove(remote);
        LOGGER.info("remove session:{}", (Object)udpAioSession);
    }

    public void close() {
        ResponseUnit task;
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        for (UdpAioSession session : this.sessionMap.values()) {
            session.close();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
        if (this.failResponseUnit != null) {
            this.failResponseUnit.response.clean();
        }
    }

    DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseUnit {
        private final SocketAddress remote;
        private final VirtualBuffer response;

        public ResponseUnit(SocketAddress remote, VirtualBuffer response) {
            this.remote = remote;
            this.response = response;
        }
    }
}

