/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.NetMonitor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.UdpAioSession;
import org.smartboot.socket.transport.UdpChannel;
import org.smartboot.socket.transport.UdpDispatcher;
import org.smartboot.socket.util.DecoderException;

public class UdpBootstrap {
    private static final int MAX_READ_TIMES = 16;
    private static int UID;
    private final BufferPage bufferPage = new BufferPagePool(0x100000, 1, -1, true).allocateBufferPage();
    private final IoServerConfig config = new IoServerConfig();
    private Worker worker;
    private UdpDispatcher[] workerGroup;
    private ExecutorService executorService;
    private boolean running = true;

    public <Request> UdpBootstrap(Protocol<Request> protocol, MessageProcessor<Request> messageProcessor) {
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public UdpChannel open() throws IOException {
        return this.open(0);
    }

    public UdpChannel open(int port) throws IOException {
        return this.open(null, port);
    }

    public UdpChannel open(String host, int port) throws IOException {
        if (this.worker == null) {
            this.initThreadServer();
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            InetSocketAddress inetSocketAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            channel.socket().bind(inetSocketAddress);
        }
        UdpChannel udpChannel = new UdpChannel(channel, this.worker, this.config, this.bufferPage);
        this.worker.addRegister(selector -> {
            try {
                SelectionKey selectionKey = channel.register((Selector)selector, 1);
                udpChannel.setSelectionKey(selectionKey);
                selectionKey.attach(udpChannel);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
        return udpChannel;
    }

    private synchronized void initThreadServer() throws IOException {
        if (this.worker != null) {
            return;
        }
        if (this.config.isBannerEnabled()) {
            System.out.println("\n                               _                           _             _   \n                              ( )_                        ( )           ( )_ \n  ___   ___ ___     _ _  _ __ | ,_)     ___    _      ___ | |/')    __  | ,_)\n/',__)/' _ ` _ `\\ /'_` )( '__)| |     /',__) /'_`\\  /'___)| , <   /'__`\\| |  \n\\__, \\| ( ) ( ) |( (_| || |   | |_    \\__, \\( (_) )( (___ | |\\`\\ (  ___/| |_ \n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (____/`\\___/'`\\____)(_) (_)`\\____)`\\__)\r\n :: smart-socket[udp] ::\t(v1.5.6)");
        }
        final int uid = UID++;
        this.workerGroup = new UdpDispatcher[this.config.getThreadNum()];
        this.executorService = new ThreadPoolExecutor(this.config.getThreadNum(), this.config.getThreadNum(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "smart-socket:udp-" + uid + "-" + ++this.i);
            }
        });
        for (int i = 0; i < this.config.getThreadNum(); ++i) {
            this.workerGroup[i] = new UdpDispatcher(this.config.getProcessor());
            this.executorService.execute(this.workerGroup[i]);
        }
        this.worker = new Worker();
        new Thread((Runnable)this.worker, "smart-socket:udp-" + uid).start();
    }

    private void doRead(VirtualBuffer readBuffer, UdpChannel channel) throws IOException {
        int count = 16;
        while (count-- > 0) {
            Object request;
            ByteBuffer buffer = readBuffer.buffer();
            buffer.clear();
            SocketAddress remote = channel.getChannel().receive(buffer);
            if (remote == null) {
                return;
            }
            buffer.flip();
            UdpAioSession aioSession = channel.createAndCacheSession(remote);
            NetMonitor netMonitor = this.config.getMonitor();
            if (netMonitor != null) {
                netMonitor.beforeRead((AioSession)aioSession);
                netMonitor.afterRead((AioSession)aioSession, buffer.remaining());
            }
            try {
                request = this.config.getProtocol().decode(buffer, (AioSession)aioSession);
            }
            catch (Exception e) {
                this.config.getProcessor().stateEvent((AioSession)aioSession, StateMachineEnum.DECODE_EXCEPTION, (Throwable)e);
                aioSession.close();
                throw e;
            }
            if (request == null) {
                this.config.getProcessor().stateEvent((AioSession)aioSession, StateMachineEnum.DECODE_EXCEPTION, (Throwable)new DecoderException("decode result is null"));
                continue;
            }
            this.workerGroup[(remote.hashCode() & Integer.MAX_VALUE) % this.workerGroup.length].dispatch(aioSession, request);
        }
    }

    public void shutdown() {
        this.running = false;
        this.worker.selector.wakeup();
        for (UdpDispatcher dispatcher : this.workerGroup) {
            dispatcher.dispatch(UdpDispatcher.EXECUTE_TASK_OR_SHUTDOWN);
        }
        this.executorService.shutdown();
    }

    public final UdpBootstrap setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }

    public final UdpBootstrap setBannerEnabled(boolean bannerEnabled) {
        this.config.setBannerEnabled(bannerEnabled);
        return this;
    }

    class Worker
    implements Runnable {
        private final Selector selector;
        private final ConcurrentLinkedQueue<Consumer<Selector>> registers = new ConcurrentLinkedQueue();

        Worker() throws IOException {
            this.selector = Selector.open();
        }

        final void addRegister(Consumer<Selector> register) {
            this.registers.offer(register);
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            VirtualBuffer readBuffer = UdpBootstrap.this.bufferPage.allocate(UdpBootstrap.this.config.getReadBufferSize());
            try {
                while (UdpBootstrap.this.running) {
                    Consumer<Selector> register;
                    while ((register = this.registers.poll()) != null) {
                        register.accept(this.selector);
                    }
                    if (keySet.isEmpty() && this.selector.select() == 0) continue;
                    Iterator<SelectionKey> keyIterator = keySet.iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        keyIterator.remove();
                        UdpChannel udpChannel = (UdpChannel)key.attachment();
                        if (!key.isValid()) {
                            udpChannel.close();
                            continue;
                        }
                        if (key.isReadable()) {
                            UdpBootstrap.this.doRead(readBuffer, udpChannel);
                        }
                        if (!key.isWritable()) continue;
                        udpChannel.doWrite();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                readBuffer.clean();
            }
        }
    }
}

