/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.UdpChannel;
import org.smartboot.socket.transport.WriteBuffer;

final class UdpAioSession
extends AioSession {
    private final UdpChannel udpChannel;
    private final SocketAddress remote;
    private final WriteBuffer writeBuffer;

    UdpAioSession(UdpChannel udpChannel, SocketAddress remote, WriteBuffer writeBuffer) {
        this.udpChannel = udpChannel;
        this.remote = remote;
        this.writeBuffer = writeBuffer;
        udpChannel.config.getProcessor().stateEvent((AioSession)this, StateMachineEnum.NEW_SESSION, null);
    }

    public WriteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    public void awaitRead() {
        throw new UnsupportedOperationException();
    }

    public void signalRead() {
        throw new UnsupportedOperationException();
    }

    public void close(boolean immediate) {
        this.writeBuffer.close();
        this.udpChannel.config.getProcessor().stateEvent((AioSession)this, StateMachineEnum.SESSION_CLOSED, null);
        this.udpChannel.removeSession(this.remote);
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.udpChannel.getChannel().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.remote;
    }
}

