/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.QuickTimerTask;

public final class MonitorPlugin<T>
extends AbstractPlugin<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorPlugin.class);
    private final LongAdder inFlow = new LongAdder();
    private final LongAdder outFlow = new LongAdder();
    private final LongAdder processFailNum = new LongAdder();
    private final LongAdder processMsgNum = new LongAdder();
    private final LongAdder totleProcessMsgNum = new LongAdder();
    private final LongAdder newConnect = new LongAdder();
    private final LongAdder disConnect = new LongAdder();
    private final LongAdder totalConnect = new LongAdder();
    private final LongAdder readCount = new LongAdder();
    private final LongAdder writeCount = new LongAdder();
    private int seconds;
    private long onlineCount;

    public MonitorPlugin() {
        this(60);
    }

    public MonitorPlugin(int seconds) {
        this.seconds = seconds;
        long mills = TimeUnit.SECONDS.toMillis(seconds);
        QuickTimerTask.scheduleAtFixedRate(this, mills, mills);
    }

    @Override
    public boolean preProcess(AioSession session, T t) {
        this.processMsgNum.increment();
        this.totleProcessMsgNum.increment();
        return true;
    }

    @Override
    public void stateEvent(StateMachineEnum stateMachineEnum, AioSession session, Throwable throwable) {
        switch (stateMachineEnum) {
            case PROCESS_EXCEPTION: {
                this.processFailNum.increment();
                break;
            }
            case NEW_SESSION: {
                this.newConnect.increment();
                break;
            }
            case SESSION_CLOSED: {
                this.disConnect.increment();
                break;
            }
        }
    }

    @Override
    public void run() {
        long curInFlow = this.getAndReset(this.inFlow);
        long curOutFlow = this.getAndReset(this.outFlow);
        long curDiscardNum = this.getAndReset(this.processFailNum);
        long curProcessMsgNum = this.getAndReset(this.processMsgNum);
        long connectCount = this.getAndReset(this.newConnect);
        long disConnectCount = this.getAndReset(this.disConnect);
        this.onlineCount += connectCount - disConnectCount;
        logger.info("\r\n-----" + this.seconds + "seconds ----\r\ninflow:\t\t" + (double)curInFlow * 1.0 / 1048576.0 + "(MB)\r\noutflow:\t" + (double)curOutFlow * 1.0 / 1048576.0 + "(MB)\r\nprocess fail:\t" + curDiscardNum + "\r\nprocess success:\t" + curProcessMsgNum + "\r\nprocess total:\t" + this.totleProcessMsgNum.longValue() + "\r\nread count:\t" + this.getAndReset(this.readCount) + "\twrite count:\t" + this.getAndReset(this.writeCount) + "\r\nconnect count:\t" + connectCount + "\r\ndisconnect count:\t" + disConnectCount + "\r\nonline count:\t" + this.onlineCount + "\r\nconnected total:\t" + this.getAndReset(this.totalConnect) + "\r\nRequests/sec:\t" + (double)curProcessMsgNum * 1.0 / (double)this.seconds + "\r\nTransfer/sec:\t" + (double)curInFlow * 1.0 / 1048576.0 / (double)this.seconds + "(MB)");
    }

    private long getAndReset(LongAdder longAdder) {
        long result = longAdder.longValue();
        longAdder.add(-result);
        return result;
    }

    @Override
    public void afterRead(AioSession session, int readSize) {
        if (readSize == 0) {
            logger.error("readSize is 0");
        }
        this.inFlow.add(readSize);
    }

    @Override
    public void beforeRead(AioSession session) {
        this.readCount.increment();
    }

    @Override
    public void afterWrite(AioSession session, int writeSize) {
        this.outFlow.add(writeSize);
    }

    @Override
    public void beforeWrite(AioSession session) {
        this.writeCount.increment();
    }
}

