/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4FLogFactory
extends LogFactory {
    Map loggerMap;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();

    public SLF4FLogFactory() {
        this.loggerMap = new HashMap();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement((String)keys.nextElement());
        }
        String[] results = new String[names.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)names.elementAt(i);
        }
        return results;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Log instance = (Log)this.loggerMap.get(name);
        if (instance == null) {
            Logger logger = LoggerFactory.getLogger((String)name);
            instance = new SLF4JLog(logger);
            this.loggerMap.put(name, instance);
        }
        return instance;
    }

    public void release() {
        System.out.println("WARN: The method " + SLF4FLogFactory.class + "#release() was invoked.");
        System.out.println("WARN: Please see http://www.slf4j.org/codes.html for an explanation.");
        System.out.flush();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }
}

