/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import org.sitoolkit.tester.RegexHelper;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;

public class WaitOperation
extends SeleniumOperation {
    private int timeout = 1;
    private int waitSpan = 100;

    @Override
    public void execute(TestScript testScript) {
        this.log.info("{}({})\u306b{}\u304c\u8868\u793a\u3055\u308c\u308b\u307e\u3067{}\u79d2\u9593\u5f85\u6a5f\u3057\u307e\u3059\u3002", new Object[]{testScript.getItemName(), testScript.getLocator(), testScript.getValue(), this.getTimeout()});
        String text = this.findElement(testScript.getLocator()).getText();
        int count = this.getTimeout() * 1000 / this.getWaitSpan();
        for (int i = 0; i < count && !RegexHelper.matches(testScript.getValue(), text); ++i) {
            try {
                Thread.sleep(this.getWaitSpan());
                continue;
            }
            catch (InterruptedException e) {
                this.log.warn("\u30b9\u30ec\u30c3\u30c9\u306e\u5f85\u6a5f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getWaitSpan() {
        return this.waitSpan;
    }

    public void setWaitSpan(int waitSpan) {
        this.waitSpan = waitSpan;
    }
}

