/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreElementIndexOperation
extends SeleniumOperation {
    @Autowired
    TestContext context;
    private int indexDefault = 1;

    @Override
    public void execute(TestScript testScript) {
        WebElement element = this.findElement(testScript.getLocator());
        WebElement parent = element.findElement(By.xpath((String)".."));
        int idx = this.getIndexDefault();
        for (WebElement child : parent.findElements(By.xpath((String)"/*"))) {
            if (element.getLocation().equals((Object)child.getLocation())) break;
            ++idx;
        }
        this.log.debug("element:{}, elementIndex:{}", (Object)element, (Object)idx);
        this.context.addParam(testScript.getDataType(), idx);
    }

    public int getIndexDefault() {
        return this.indexDefault;
    }

    public void setIndexDefault(int indexDefault) {
        this.indexDefault = indexDefault;
    }
}

