/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.core.infra.repository.DocumentRepository;
import org.sitoolkit.core.infra.repository.TableDataCatalog;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptConvertUtils;
import org.sitoolkit.tester.selenium.SeleniumTestScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component
public class SeleniumTestScriptConverter {
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    DocumentRepository docRepo;
    @Autowired
    TestScriptConvertUtils testScriptConvertUtils;
    @Resource(name="seleniumIdeCommandMap")
    Map<String, String> seleniumIdeCommandMap;
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumTestScriptConverter.class);
    private static final String SYSPROP_TEST_SCRIPT_DIR = "testScriptDir";
    private static final String TEMPLATE_PATH = "src/main/resources/TestScriptTemplate.xlsx";
    private static final String CASE_NO = "001";

    public static void main(String[] args) {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("classpath:sit-tester-conf.xml");
        SeleniumTestScriptConverter converter = (SeleniumTestScriptConverter)appCtx.getBean(SeleniumTestScriptConverter.class);
        System.exit(converter.execute());
    }

    public int execute() {
        File scriptDir = new File(System.getProperty(SYSPROP_TEST_SCRIPT_DIR, "src/test/resources/testscript"));
        if (!scriptDir.exists()) {
            scriptDir = new File(".");
        }
        for (File scriptFile : FileUtils.listFiles((File)scriptDir, (String[])new String[]{"html"}, (boolean)true)) {
            this.convert(scriptFile);
        }
        return 0;
    }

    public File convert(File seleniumIdeFile) {
        List<SeleniumTestScript> list = this.convertTestScriptHTML(seleniumIdeFile);
        List<TestScript> testScriptList = this.convertTestScript(list, CASE_NO);
        TableDataCatalog catalog = this.testScriptConvertUtils.getTableDataCatalog(testScriptList);
        File sitScriptFile = new File(seleniumIdeFile.getParent(), seleniumIdeFile.getName().replace(".html", ".xlsx"));
        this.docRepo.write(TEMPLATE_PATH, sitScriptFile.getPath(), catalog);
        return sitScriptFile;
    }

    private List<SeleniumTestScript> convertTestScriptHTML(File file) {
        Document doc = this.parse(file);
        NodeList tdList = doc.getElementsByTagName("td");
        ArrayList<SeleniumTestScript> list = new ArrayList<SeleniumTestScript>();
        SeleniumTestScript script = new SeleniumTestScript();
        block5: for (int i = 1; i < tdList.getLength(); ++i) {
            String nodeValue = tdList.item(i).getTextContent();
            switch ((i - 1) % 3) {
                case 0: {
                    script.setCommand(nodeValue);
                    continue block5;
                }
                case 1: {
                    script.setTarget(nodeValue);
                    continue block5;
                }
                case 2: {
                    script.setValue(nodeValue);
                    list.add(script);
                    LOG.debug("Selenium\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u30921\u884c\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3000command:{},target:{},value:{}", new Object[]{script.getCommand(), script.getTarget(), script.getValue()});
                    script = new SeleniumTestScript();
                }
            }
        }
        return list;
    }

    private Document parse(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder.parse(file);
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    private List<TestScript> convertTestScript(List<SeleniumTestScript> list, String caseNo) {
        ArrayList<TestScript> testScriptList = new ArrayList<TestScript>();
        for (SeleniumTestScript seleniumScript : list) {
            TestScript sitScript = (TestScript)this.appCtx.getBean(TestScript.class);
            sitScript.setCurrentCaseNo(caseNo);
            String operationName = this.seleniumIdeCommandMap.get(seleniumScript.getCommand());
            if (operationName == null) {
                if (this.appCtx.containsBeanDefinition(seleniumScript.getCommand() + "Operation")) {
                    sitScript.setOperationName(seleniumScript.getCommand());
                } else {
                    LOG.info("Selenium\u30b3\u30de\u30f3\u30c9\uff1a{}\u306f\u975e\u5bfe\u5fdc\u3067\u3059\u3002\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u64cd\u4f5c\u306f\u7a7a\u767d\u3067\u51fa\u529b\u3057\u307e\u3059\u3002", (Object)seleniumScript.getCommand());
                }
            } else {
                sitScript.setOperationName(operationName);
            }
            Locator locator = this.buildLocator(seleniumScript.getTarget());
            sitScript.setLocator(locator);
            this.setTestData(sitScript, caseNo, seleniumScript.getValue());
            testScriptList.add(sitScript);
        }
        return testScriptList;
    }

    private Locator buildLocator(String target) {
        String[] pair = StringUtils.split((String)target, (String)"=");
        switch (pair.length) {
            case 0: {
                return Locator.build("", "");
            }
            case 1: {
                return Locator.build("", pair[0]);
            }
        }
        return Locator.build(pair[0], pair[1]);
    }

    private void setTestData(TestScript script, String caseNo, String value) {
        HashMap<String, String> testData = new HashMap<String, String>();
        String[] pair = StringUtils.split((String)value, (String)"=");
        if (pair.length == 2) {
            script.setDataType(pair[0]);
            testData.put(caseNo, pair[1]);
        } else if (StringUtils.isBlank((CharSequence)value)) {
            testData.put(caseNo, "y");
        } else {
            testData.put(caseNo, value);
        }
        script.setTestData(testData);
    }
}

