/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.sitoolkit.tester.ElementPosition;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.Operation;
import org.sitoolkit.tester.OperationLog;
import org.sitoolkit.tester.selenium.ElementPositionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SeleniumOperation
implements Operation {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OperationLog opelog;
    @Autowired
    WebDriver seleniumDriver;
    @Autowired
    ElementPositionSupport position;

    protected By by(Locator locator) {
        switch (locator.getTypeVo()) {
            case css: {
                return By.cssSelector((String)locator.getValue());
            }
            case name: {
                return By.name((String)locator.getValue());
            }
            case xpath: {
                return By.xpath((String)locator.getValue());
            }
            case link: {
                return By.linkText((String)locator.getValue());
            }
            case tag: {
                return By.tagName((String)locator.getValue());
            }
        }
        return By.id((String)locator.getValue());
    }

    protected WebElement findElement(Locator locator) {
        return this.seleniumDriver.findElement(this.by(locator));
    }

    protected List<WebElement> findElements(Locator locator) {
        return this.seleniumDriver.findElements(this.by(locator));
    }

    protected boolean setChecked(WebElement checkElement, WebElement clickElement, boolean checked) {
        this.log.debug("checkElement:{}, clickElement:{}, checked:{}", new Object[]{checkElement, clickElement, checked});
        if (checkElement.isSelected() != checked) {
            clickElement.click();
            return true;
        }
        return false;
    }

    protected void info(String verb, WebElement element) {
        ElementPosition pos = this.position.get(element);
        this.opelog.info(this.log, verb, pos);
    }

    protected void info(String object, String verb, WebElement element) {
        ElementPosition pos = this.position.get(element);
        this.opelog.info(this.log, object, verb, pos);
    }

    public void info(WebElement element, String messagePattern, Object ... params) {
        ElementPosition pos = this.position.get(element);
        this.opelog.info(this.log, pos, messagePattern, params);
    }

    protected void addPosition(WebElement element) {
        this.opelog.addPosition(this.position.get(element));
    }
}

