/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import org.sitoolkit.tester.ElementPosition;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestContextListener;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptCatalog;
import org.sitoolkit.tester.selenium.SeleniumOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class IncludeOperation
extends SeleniumOperation
implements TestContextListener {
    private static final String SHEET_NAME = "TestScript";
    private static final String TEST_RESOURCE_PATH = "src/test/resources/";
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    TestContext current;

    @Override
    public void execute(TestScript testScript) {
        String testScriptName = testScript.getLocator().getValue();
        this.opelog.info(this.log, ElementPosition.EMPTY, "\u30b9\u30af\u30ea\u30d7\u30c8[{}]\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002", testScriptName);
        this.current.backup();
        TestScriptCatalog catalog = (TestScriptCatalog)this.appCtx.getBean(TestScriptCatalog.class);
        catalog.load(TEST_RESOURCE_PATH + testScriptName, SHEET_NAME);
        this.current.setCatalog(catalog);
        this.current.reset();
        this.current.setTestContextListener(this);
    }

    @Override
    public void onEnd(TestContext testContext) {
        testContext.restore();
        testContext.setTestContextListener(null);
    }
}

