/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.sitoolkit.tester.ElementPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class ElementPositionSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    WebDriver seleniumDriver;
    private WebElement currentFrame;

    public WebElement getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(WebElement currentFrame) {
        this.currentFrame = currentFrame;
    }

    public Point getCurrentBasePosition() {
        if (this.currentFrame == null) {
            return this.seleniumDriver.findElement(By.tagName((String)"html")).getLocation();
        }
        this.seleniumDriver.switchTo().defaultContent();
        Point documentPos = this.seleniumDriver.findElement(By.tagName((String)"html")).getLocation();
        Point framePos = this.currentFrame.getLocation();
        this.seleniumDriver.switchTo().frame(this.currentFrame);
        return new Point(documentPos.getX() - framePos.getX(), documentPos.getY() - framePos.getY());
    }

    public ElementPosition get(WebElement element) {
        if (element == null) {
            return ElementPosition.EMPTY;
        }
        if (this.seleniumDriver instanceof TakesScreenshot) {
            Point elementPos = element.getLocation();
            Point basePos = this.getCurrentBasePosition();
            this.log.debug("\u8981\u7d20:{}, \u8981\u7d20\u4f4d\u7f6e:{}, \u57fa\u6e96\u4f4d\u7f6e:{}", new Object[]{element, elementPos, basePos});
            return new ElementPosition(elementPos.getX() - basePos.getX(), elementPos.getY() - basePos.getY(), element.getSize().getWidth(), element.getSize().getHeight());
        }
        return ElementPosition.EMPTY;
    }
}

