/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.util.ArrayList;
import org.apache.commons.lang3.math.NumberUtils;
import org.sitoolkit.tester.DebugSupport;
import org.sitoolkit.tester.DialogScreenshotSupport;
import org.sitoolkit.tester.OperationLog;
import org.sitoolkit.tester.ScreenshotOperation;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptCatalog;
import org.sitoolkit.tester.VerifyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class Tester {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    OperationLog opelog;
    @Autowired
    TestContext current;
    @Autowired
    DebugSupport debug;
    @Autowired
    DialogScreenshotSupport dialog;
    private ScreenshotOperation screenshotOpe;
    private boolean scriptLoaded = false;
    private TestScriptCatalog catalog;

    public void setUp() {
    }

    public void setUpClass(String testScriptPath, String sheetName) {
        if (!this.isScriptLoaded()) {
            this.log.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002{}, {}", (Object)testScriptPath, (Object)sheetName);
            this.catalog = (TestScriptCatalog)this.appCtx.getBean(TestScriptCatalog.class);
            this.catalog.load(testScriptPath, sheetName);
            this.current.setCatalog(this.catalog);
        }
    }

    public void tearDown() {
        this.opelog.flush();
    }

    public void tearDownClass() {
        this.opelog.moveLogFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int operate(String caseNo) {
        if (!this.catalog.containsCaseNo(caseNo)) {
            throw new TestException("\u4e0d\u6b63\u306a\u30b1\u30fc\u30b9\u756a\u53f7\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f" + caseNo);
        }
        this.current.reset();
        this.current.setCaseNo(caseNo);
        this.current.setScriptName(this.catalog.getName());
        this.dialog.checkReserve(this.catalog.getTestScriptList(), caseNo);
        this.log.info("\u30b1\u30fc\u30b9{}\u3092\u5b9f\u884c\u3057\u307e\u3059", (Object)caseNo);
        ArrayList<Exception> ngList = new ArrayList<Exception>();
        block5: while (true) {
            try {
                while (this.debug.next()) {
                    TestScript testScript = this.current.getTestScript();
                    this.dialog.reserveWindowRect(testScript.getNo());
                    try {
                        this.operateOneScript(testScript, caseNo);
                        continue block5;
                    }
                    catch (VerifyException e) {
                        ngList.add(e);
                        this.log.warn("\u671f\u5f85\u3068\u7570\u306a\u308b\u7d50\u679c\u306b\u306a\u308a\u307e\u3057\u305f", (Throwable)e);
                        this.opelog.addScreenshot(this.screenshotOpe.get());
                    }
                    catch (Exception e) {
                        if (!this.debug.isDebug()) throw e;
                        ngList.add(e);
                        this.log.error("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)e);
                        this.opelog.addScreenshot(this.screenshotOpe.get());
                        this.debug.pause();
                        continue;
                        return ngList.size();
                    }
                }
            }
            catch (Exception e) {
                this.opelog.addScreenshot(this.screenshotOpe.get(), "\u30c6\u30b9\u30c8\u5b9f\u65bd\u304c\u7570\u5e38\u7d42\u4e86");
                this.opelog.error(this.log, e.getMessage());
                throw new TestException("\u30c6\u30b9\u30c8\u5b9f\u65bd\u304c\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f" + e.getMessage(), e);
            }
        }
    }

    void operateOneScript(TestScript testScript, String caseNo) {
        testScript.setCurrentCaseNo(caseNo);
        if (testScript.isSkip()) {
            this.log.info("\u30b1\u30fc\u30b9[{}][{} {}]\u306e\u64cd\u4f5c\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059", new Object[]{caseNo, testScript.getNo(), testScript.getItemName()});
            return;
        }
        boolean screenshotted = false;
        if (testScript.dialogScreenshot()) {
            this.opelog.addScreenshot(this.screenshotOpe.getWithDialog(), "", false);
        } else if (testScript.beforeScreenshot()) {
            this.opelog.addScreenshot(this.screenshotOpe.get(), "\u524d");
            screenshotted = true;
        }
        testScript.execute();
        if (testScript.afterScreenshot()) {
            this.opelog.addScreenshot(this.screenshotOpe.get(), "\u5f8c");
            screenshotted = true;
        }
        if (screenshotted) {
            this.opelog.renewPositionList();
        }
        try {
            Thread.sleep(this.getOperationSpan());
        }
        catch (InterruptedException e) {
            this.log.warn("\u30b9\u30ec\u30c3\u30c9\u306e\u5f85\u6a5f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    public int getOperationSpan() {
        return NumberUtils.toInt((String)System.getProperty("operationSpan"), (int)0);
    }

    public boolean isScriptLoaded() {
        return this.scriptLoaded;
    }

    public ScreenshotOperation getScreenshotOpe() {
        return this.screenshotOpe;
    }

    public void setScreenshotOpe(ScreenshotOperation screenshotOpe) {
        this.screenshotOpe = screenshotOpe;
    }
}

