/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.core.infra.repository.DocumentMapper;
import org.sitoolkit.core.infra.repository.DocumentRepository;
import org.sitoolkit.core.infra.repository.RowData;
import org.sitoolkit.core.infra.repository.TableData;
import org.sitoolkit.tester.Operation;
import org.sitoolkit.tester.OperationConverter;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
@Scope(value="prototype")
public class TestScriptCatalog {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    OperationConverter operationConverter;
    private String caseNoPrefix = "\u30b1\u30fc\u30b9_";
    private int caseNoColIndex;
    private List<TestScript> testScriptList = new ArrayList<TestScript>();
    private Map<String, Integer> testScriptNoMap = new HashMap<String, Integer>();
    private Map<String, Integer> caseNoMap = new HashMap<String, Integer>();
    private String name;
    private boolean loadCaseOnly;
    private long lastModified;
    private File scriptFile;
    private String sheetName;

    public String getCaseNoPrefix() {
        return this.caseNoPrefix;
    }

    public void setCaseNoPrefix(String caseNoPrefix) {
        this.caseNoPrefix = caseNoPrefix;
    }

    public List<TestScript> getTestScriptList() {
        return Collections.unmodifiableList(this.testScriptList);
    }

    public void addTestScript(TestScript testScript) {
        if (testScript != null && testScript.getOperation() != null) {
            this.testScriptList.add(testScript);
            this.testScriptNoMap.put(testScript.getNo(), this.testScriptList.size() - 1);
        }
    }

    public TestScript getTestScript(int index) {
        return this.testScriptList.get(index);
    }

    public int getTestScriptCount() {
        return this.testScriptList.size();
    }

    public Integer getScriptIndex(String scriptNo) {
        return this.testScriptNoMap.get(scriptNo);
    }

    public void setTestScriptList(List<TestScript> testScriptList) {
        this.testScriptList = testScriptList;
    }

    public Map<String, Integer> getCaseNoMap() {
        return this.caseNoMap;
    }

    public void setCaseNoMap(Map<String, Integer> caseNoMap) {
        this.caseNoMap = caseNoMap;
    }

    public boolean containsCaseNo(String caseNo) {
        return this.caseNoMap.containsKey(caseNo);
    }

    public void reload() {
        this.testScriptList.clear();
        this.load(this.scriptFile.getAbsolutePath(), this.sheetName);
    }

    public void load(String testScriptPath, String sheetName) {
        this.sheetName = sheetName;
        if (testScriptPath.endsWith(".xlsx") || testScriptPath.endsWith("xls")) {
            this.loadScriptFromExcel(testScriptPath, sheetName);
        } else if (testScriptPath.endsWith(".csv")) {
            this.loadScriptFromCsv(testScriptPath);
        }
    }

    public void loadScriptFromExcel(String testScriptPath, String sheetName) {
        Object lastRow = null;
        DocumentRepository repo = (DocumentRepository)this.appCtx.getBean(DocumentRepository.class);
        TableData table = repo.read(testScriptPath, sheetName);
        DocumentMapper dm = (DocumentMapper)this.appCtx.getBean(DocumentMapper.class);
        RowData firstRow = (RowData)table.getRows().iterator().next();
        int testDataIndex = 0;
        for (Map.Entry entry : firstRow.getData().entrySet()) {
            if (!((String)entry.getKey()).startsWith(this.getCaseNoPrefix())) continue;
            String caseNo = StringUtils.substringAfter((String)((String)entry.getKey()), (String)this.getCaseNoPrefix());
            this.caseNoMap.put(caseNo, testDataIndex++);
        }
        if (this.isLoadCaseOnly()) {
            return;
        }
        for (RowData row : repo.read(testScriptPath, sheetName).getRows()) {
            TestScript testScript = (TestScript)dm.map("testScript", row, TestScript.class);
            this.addTestScript(testScript);
        }
        try {
            this.scriptFile = ResourceUtils.getFile((String)testScriptPath);
            this.lastModified = this.scriptFile.lastModified();
            this.setName(this.scriptFile.getName());
        }
        catch (FileNotFoundException e) {
            throw new TestException(e);
        }
    }

    public void loadScriptFromCsv(String testScriptPath) {
        List lineList = null;
        try {
            this.scriptFile = ResourceUtils.getFile((String)testScriptPath);
            this.lastModified = this.scriptFile.lastModified();
            this.setName(this.scriptFile.getName());
            lineList = FileUtils.readLines((File)this.scriptFile, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new TestException(e);
        }
        this.loadHeader((String)lineList.get(0));
        if (this.isLoadCaseOnly()) {
            return;
        }
        for (String line : lineList.subList(1, lineList.size())) {
            if (line.startsWith("#")) {
                this.log.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u9664\u5916\u3057\u307e\u3059\u3002{}", (Object)line);
                continue;
            }
            Object[] values = this.splitLine(line);
            this.log.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u8ffd\u52a0\u3057\u307e\u3059\u3002{}", (Object)Arrays.toString(values));
            TestScript testScript = (TestScript)this.appCtx.getBean(TestScript.class);
            testScript.setNo(CsvColumn.no.get((String[])values));
            testScript.setItemName(CsvColumn.itemName.get((String[])values));
            testScript.setOperation((Operation)this.operationConverter.convert(null, CsvColumn.operation.get((String[])values)));
            testScript.getLocator().setType(CsvColumn.locatorType.get((String[])values));
            testScript.getLocator().setValue(CsvColumn.locator.get((String[])values));
            testScript.setDataType(CsvColumn.dataType.get((String[])values));
            testScript.setScreenshotTiming(CsvColumn.screenshotTiming.get((String[])values));
            HashMap<String, String> testDataMap = new HashMap<String, String>();
            String[] testData = (String[])ArrayUtils.subarray((Object[])values, (int)this.caseNoColIndex, (int)values.length);
            for (Map.Entry<String, Integer> entry : this.caseNoMap.entrySet()) {
                String value = entry.getValue() < testData.length ? testData[entry.getValue()] : "";
                testDataMap.put(entry.getKey(), value);
            }
            this.log.debug("\u30c6\u30b9\u30c8\u30c7\u30fc\u30bf\u3092\u8ffd\u52a0\u3057\u307e\u3059\u3002{}", testDataMap);
            testScript.setTestData(testDataMap);
            this.addTestScript(testScript);
        }
    }

    public boolean isLoadCaseOnly() {
        return this.loadCaseOnly;
    }

    public void setLoadCaseOnly(boolean loadCaseOnly) {
        this.loadCaseOnly = loadCaseOnly;
    }

    public boolean isScriptFileChanged() {
        return this.lastModified != this.scriptFile.lastModified();
    }

    void loadHeader(String header) {
        Object[] cells = this.splitLine(header);
        for (int i = 0; i < cells.length; ++i) {
            if (!cells[i].startsWith(this.getCaseNoPrefix())) continue;
            this.caseNoColIndex = i;
            break;
        }
        int testDataIndex = 0;
        for (String cell : (String[])ArrayUtils.subarray((Object[])cells, (int)this.caseNoColIndex, (int)cells.length)) {
            String caseNo = StringUtils.substringAfter((String)cell, (String)this.getCaseNoPrefix());
            this.caseNoMap.put(caseNo, testDataIndex++);
        }
        this.log.info("{}\u4ef6\u306e\u30b1\u30fc\u30b9\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002{}", (Object)this.caseNoMap.size(), this.caseNoMap.keySet());
    }

    String[] splitLine(String line) {
        String[] values = line.split(",|\t");
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            values[i] = value.substring(1, value.length() - 1);
        }
        return values;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndexByScriptNo(String no) {
        return this.testScriptNoMap.get(no);
    }

    static enum CsvColumn {
        no(0),
        itemName(1),
        operation(2),
        locatorType(3),
        locator(4),
        dataType(5),
        screenshotTiming(6);

        private int idx;

        private CsvColumn(int idx) {
            this.idx = idx;
        }

        public int getIdx() {
            return this.idx;
        }

        public String get(String[] values) {
            return values.length <= this.getIdx() ? "" : values[this.getIdx()];
        }
    }
}

