/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.sitoolkit.tester.TestContextListener;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptCatalog;
import org.springframework.stereotype.Component;

@Component(value="current")
public class TestContext {
    private TestScriptCatalog catalog;
    private TestScript testScript;
    private String scriptName;
    private String caseNo;
    private TestScriptCatalog catalogTmp;
    private TestContextListener testContextListener;
    private int currentIndex;
    private int indexTmp;
    private Rectangle windowRect;
    private Map<String, Object> params = new HashMap<String, Object>();

    public TestScriptCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(TestScriptCatalog catalog) {
        this.catalog = catalog;
    }

    public TestScript getTestScript() {
        return this.testScript;
    }

    public void setTestScript(TestScript testScript) {
        this.testScript = testScript;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getCaseNo() {
        return this.caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    public TestScriptCatalog getCatalogTmp() {
        return this.catalogTmp;
    }

    public void setCatalogTmp(TestScriptCatalog catalogTmp) {
        this.catalogTmp = catalogTmp;
    }

    public TestContextListener getTestContextListener() {
        return this.testContextListener;
    }

    public void setTestContextListener(TestContextListener testContextListener) {
        this.testContextListener = testContextListener;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public <T> T getParam(String key) {
        return (T)this.params.get(key);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public boolean next() {
        if (this.getCurrentIndex() < this.getCatalog().getTestScriptCount()) {
            TestScript ts = this.getCatalog().getTestScript(this.currentIndex++);
            this.setTestScript(ts);
            return true;
        }
        if (this.testContextListener != null) {
            this.testContextListener.onEnd(this);
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void reset() {
        this.setCurrentIndex(0);
    }

    public Rectangle getWindowRect() {
        return this.windowRect;
    }

    public void setWindowRect(Rectangle windowRect) {
        this.windowRect = windowRect;
    }

    public void setWindowRect(int x, int y, int w, int h) {
        this.setWindowRect(new Rectangle(x, y, w, h));
    }

    public int getIndexTmp() {
        return this.indexTmp;
    }

    public void setIndexTmp(int indexTmp) {
        this.indexTmp = indexTmp;
    }

    public void backup() {
        this.catalogTmp = this.catalog;
        this.indexTmp = this.currentIndex;
    }

    public void restore() {
        this.catalog = this.catalogTmp;
        this.currentIndex = this.indexTmp;
        this.testScript = this.catalog.getTestScript(this.currentIndex++);
    }
}

