/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.core.infra.srccd.SourceCode;
import org.sitoolkit.core.infra.util.SitFileUtils;
import org.sitoolkit.core.infra.util.TextFile;
import org.sitoolkit.tester.SitPathUtils;
import org.sitoolkit.tester.TestScriptCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TestClassGenerator
extends SourceCode {
    private static final Logger LOG = LoggerFactory.getLogger(TestClassGenerator.class);
    public static final String SYSPROP_TEST_SCRIPT_DIR = "testScriptDir";
    public static final String SYSPROP_TESTS_SCRIPT_PATH = "testsScriptPath";
    @Autowired
    ApplicationContext appCtx;
    private List<String> caseNos = new ArrayList<String>();
    private String scriptPath;
    private String sheetName = "TestScript";
    private String timestampFileName = "timestamp.xml";
    private Properties timestampLog = new Properties();
    private String pkg;

    public TestClassGenerator() {
        this.setTemplate("/testclass-template.vm");
        this.setVar("test");
        this.setFileExt("java");
        this.setOverwrite(true);
    }

    public static void main(String[] args) {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("classpath:sit-tester-conf.xml");
        TestClassGenerator testGen = (TestClassGenerator)((Object)appCtx.getBean(TestClassGenerator.class));
        System.exit(testGen.execute());
    }

    public int execute() {
        this.loadTimestampFile();
        String scriptPathes = System.getProperty(SYSPROP_TESTS_SCRIPT_PATH);
        if (StringUtils.isNotEmpty((CharSequence)scriptPathes)) {
            for (String path : scriptPathes.split(",")) {
                this.generate(new File(path));
            }
        } else {
            File scriptDir = new File(System.getProperty(SYSPROP_TEST_SCRIPT_DIR, "src/test/resources/testscript"));
            if (!scriptDir.exists()) {
                scriptDir = new File(".");
            }
            for (File scriptFile : FileUtils.listFiles((File)scriptDir, (String[])new String[]{"csv", "xls", "xlsx"}, (boolean)true)) {
                this.generate(scriptFile);
            }
        }
        this.storeTimestampFile();
        return 0;
    }

    public void generate(File scriptFile) {
        String lastModified_;
        if (scriptFile.getName().startsWith("~$")) {
            LOG.debug("\u30b7\u30b9\u30c6\u30e0\u30d5\u30a1\u30a4\u30eb\u306e\u305f\u3081\u751f\u6210\u51e6\u7406\u304b\u3089\u9664\u5916\u3057\u307e\u3059 {}", (Object)scriptFile.getAbsolutePath());
            return;
        }
        String lastModified = Long.toString(scriptFile.lastModified());
        if (lastModified.equals(lastModified_ = this.timestampLog.getProperty(scriptFile.getAbsolutePath()))) {
            LOG.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u30c6\u30b9\u30c8\u30af\u30e9\u30b9\u306f\u6700\u65b0\u306e\u72b6\u614b\u3067\u3059 {}", (Object)scriptFile.getAbsolutePath());
            return;
        }
        this.timestampLog.put(scriptFile.getAbsolutePath(), lastModified);
        this.setScriptPath(SitPathUtils.relatvePath(new File("."), scriptFile));
        this.setPname(StringUtils.capitalize((String)this.toBaseName(this.getScriptPath())) + "Test");
        String path = FilenameUtils.getPath((String)this.scriptPath).replace("src/test/resources/testscript/", "");
        this.setOutDir(System.getProperty("testSrcDir", "target/generated-test-sources/test/" + path));
        if (StringUtils.isEmpty((CharSequence)path)) {
            this.setPkg(null);
        } else {
            this.setPkg(StringUtils.substringBeforeLast((String)path, (String)"/").replace("/", "."));
        }
        TestScriptCatalog catalog = (TestScriptCatalog)this.appCtx.getBean(TestScriptCatalog.class);
        catalog.setLoadCaseOnly(true);
        catalog.load(scriptFile.getAbsolutePath(), this.getSheetName());
        this.caseNos.clear();
        this.caseNos.addAll(catalog.getCaseNoMap().keySet());
        SitFileUtils.write((TextFile)this.toFile());
    }

    String toBaseName(String path) {
        return StringUtils.substringBefore((String)new File(path).getName(), (String)".");
    }

    private void loadTimestampFile() {
        File f = new File(this.getOutDir(), this.timestampFileName);
        if (f.exists()) {
            try {
                this.timestampLog.loadFromXML(FileUtils.openInputStream((File)f));
            }
            catch (IOException e) {
                LOG.warn("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
    }

    private void storeTimestampFile() {
        File f = new File(this.getOutDir(), this.timestampFileName);
        try {
            this.timestampLog.storeToXML(FileUtils.openOutputStream((File)f, (boolean)false), this.scriptPath);
        }
        catch (IOException e) {
            LOG.warn("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
        }
    }

    public List<String> getCaseNos() {
        return this.caseNos;
    }

    public void setCaseNos(List<String> caseNos) {
        this.caseNos = caseNos;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }
}

