/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.sitoolkit.tester.Tester;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AbstractTestExecutionListener;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:sit-tester-conf.xml"})
public abstract class SitTesterTestBase
extends AbstractTestExecutionListener {
    @Autowired
    protected Tester tester;

    public void beforeTestClass(TestContext testContext) throws Exception {
        Tester tester = (Tester)testContext.getApplicationContext().getBean(Tester.class);
        tester.setUpClass(this.getTestScriptPath(), this.getSheetName());
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        Tester tester = (Tester)testContext.getApplicationContext().getBean(Tester.class);
        tester.tearDownClass();
    }

    @Before
    public void setUp() {
        this.tester.setUp();
    }

    @After
    public void tearDown() {
        this.tester.tearDown();
    }

    protected abstract String getTestScriptPath();

    protected abstract String getSheetName();
}

