/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class ELSupport {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected ExpressionParser parser = new SpelExpressionParser();
    private static Pattern p = Pattern.compile("#\\{(.+?\\})");
    private EvaluationContext ctx;
    @Autowired
    protected TestContext current;

    @PostConstruct
    public void init() {
        this.ctx = new StandardEvaluationContext((Object)this.current);
    }

    public String evaludate(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        Matcher m = p.matcher(value);
        while (m.find()) {
            String expGroup = m.group();
            this.LOG.trace("value:{}, el:{}", (Object)value, (Object)expGroup);
            String expStr = expGroup.substring(2, expGroup.length() - 1);
            value = value.replace(expGroup, this.eval(expStr));
        }
        return value;
    }

    String eval(String expStr) {
        Expression exp = this.parser.parseExpression(expStr);
        return StringUtils.defaultString((String)(this.ctx == null ? (String)exp.getValue(String.class) : (String)exp.getValue(this.ctx, String.class)));
    }
}

