/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.process.ExecOperations;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AbstractRunCommandTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.BeanRegistryBuildService;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NonRunnableTaskException;

public class InstallPackageManagerTask
extends AbstractRunCommandTask {
    private static final String COREPACK_ENABLE_COMMAND = "enable";
    private final RegularFileProperty packageManagerSpecificationFile;
    private final RegularFileProperty packageManagerExecutableFile;

    @Inject
    public InstallPackageManagerTask(ObjectFactory objectFactory, ExecOperations execOperations) {
        super(objectFactory, execOperations);
        this.executableType.set((Object)ExecutableType.COREPACK);
        this.packageManagerSpecificationFile = objectFactory.fileProperty();
        this.packageManagerExecutableFile = objectFactory.fileProperty();
    }

    @InputFile
    public RegularFileProperty getPackageManagerSpecificationFile() {
        return this.packageManagerSpecificationFile;
    }

    @OutputFile
    public RegularFileProperty getPackageManagerExecutableFile() {
        return this.packageManagerExecutableFile;
    }

    @Override
    public void execute() throws NonRunnableTaskException, BeanRegistryException {
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)this.beanRegistryBuildService.get()).getBeanRegistry();
        this.executableArgs.set(this.packageManagerSpecificationFile.getAsFile().map(f -> {
            try {
                return String.join((CharSequence)" ", COREPACK_ENABLE_COMMAND, beanRegistry.getBean(FileManager.class).readString(f.toPath(), StandardCharsets.UTF_8).split("@")[0]);
            }
            catch (IOException | BeanRegistryException e) {
                throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }));
        super.execute();
    }
}

