/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.process.ExecSpec;
import org.siouan.frontendgradleplugin.domain.ExecutionSettings;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.ResolveExecutionSettings;
import org.siouan.frontendgradleplugin.domain.ResolveExecutionSettingsCommand;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ExecSpecAction;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ScriptProperties;

public class GradleScriptRunnerAdapter {
    private final ResolveExecutionSettings resolveExecutionSettings;
    private final Logger logger;

    public void execute(ScriptProperties scriptProperties) {
        ExecutionSettings executionSettings = this.resolveExecutionSettings.execute(ResolveExecutionSettingsCommand.builder().packageJsonDirectoryPath(scriptProperties.getPackageJsonDirectoryPath()).executableType(scriptProperties.getExecutableType()).nodeInstallDirectoryPath(scriptProperties.getNodeInstallDirectoryPath()).platform(scriptProperties.getPlatform()).executableArgs(scriptProperties.getExecutableArgs()).environmentVariables(scriptProperties.getEnvironmentVariables()).build());
        this.logger.debug("Execution settings: {}", executionSettings);
        scriptProperties.getExecOperations().exec((Action)ExecSpecAction.builder().executionSettings(executionSettings).afterConfiguredConsumer(this::logExecSpecBeforeExecution).build()).rethrowFailure().assertNormalExitValue();
    }

    private void logExecSpecBeforeExecution(ExecSpec execSpec) {
        this.logger.debug("Execution environment: {}", execSpec.getEnvironment());
        this.logger.info("Running '{}' with arguments: [{}]", execSpec.getExecutable(), String.join((CharSequence)"], [", execSpec.getArgs()));
    }

    @Generated
    public GradleScriptRunnerAdapter(ResolveExecutionSettings resolveExecutionSettings, Logger logger) {
        this.resolveExecutionSettings = resolveExecutionSettings;
        this.logger = logger;
    }
}

