/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.installer.DeployDistribution;
import org.siouan.frontendgradleplugin.domain.installer.DeployDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.GetDistribution;
import org.siouan.frontendgradleplugin.domain.installer.GetDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.InstallNodeDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.installer.InvalidNodeDistributionException;
import org.siouan.frontendgradleplugin.domain.installer.NodeDistributionShasumNotFoundException;
import org.siouan.frontendgradleplugin.domain.installer.ResourceDownloadException;
import org.siouan.frontendgradleplugin.domain.installer.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverException;

public class InstallNodeDistribution {
    public static final String EXTRACT_DIRECTORY_NAME = "extract";
    private final FileManager fileManager;
    private final GetDistribution getDistribution;
    private final DeployDistribution deployDistribution;
    private final Logger logger;

    public void execute(InstallNodeDistributionCommand command) throws IOException, InvalidNodeDistributionException, NodeDistributionShasumNotFoundException, UnsupportedPlatformException, InvalidDistributionUrlException, ResourceDownloadException, ArchiverException, UnsupportedDistributionArchiveException, URISyntaxException {
        this.logger.info("Removing install directory '{}'", command.installDirectoryPath());
        this.fileManager.deleteFileTree(command.installDirectoryPath(), true);
        GetDistributionCommand getDistributionCommand = new GetDistributionCommand(command.platform(), command.version(), command.distributionUrlRoot(), command.distributionUrlPathPattern(), command.distributionServerCredentials(), command.proxySettings(), command.retrySettings(), command.temporaryDirectoryPath());
        Path distributionFilePath = this.getDistribution.execute(getDistributionCommand);
        Path temporaryExplodeDirectoryPath = command.temporaryDirectoryPath().resolve(EXTRACT_DIRECTORY_NAME);
        this.logger.debug("Removing explode directory '{}'", temporaryExplodeDirectoryPath);
        this.fileManager.deleteFileTree(temporaryExplodeDirectoryPath, true);
        this.deployDistribution.execute(new DeployDistributionCommand(command.platform(), temporaryExplodeDirectoryPath, command.installDirectoryPath(), distributionFilePath));
        this.logger.info("Removing distribution file '{}'", distributionFilePath);
        this.fileManager.delete(distributionFilePath);
        this.logger.info("Distribution installed in '{}'", command.installDirectoryPath());
    }

    @Generated
    public InstallNodeDistribution(FileManager fileManager, GetDistribution getDistribution, DeployDistribution deployDistribution, Logger logger) {
        this.fileManager = fileManager;
        this.getDistribution = getDistribution;
        this.deployDistribution = deployDistribution;
        this.logger = logger;
    }
}

