/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.installer.BuildTemporaryFileName;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResource;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResourceCommand;
import org.siouan.frontendgradleplugin.domain.installer.GetDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.installer.InvalidNodeDistributionException;
import org.siouan.frontendgradleplugin.domain.installer.NodeDistributionShasumNotFoundException;
import org.siouan.frontendgradleplugin.domain.installer.ResolveNodeDistributionUrl;
import org.siouan.frontendgradleplugin.domain.installer.ResolveNodeDistributionUrlCommand;
import org.siouan.frontendgradleplugin.domain.installer.ResourceDownloadException;
import org.siouan.frontendgradleplugin.domain.installer.ValidateNodeDistribution;
import org.siouan.frontendgradleplugin.domain.installer.ValidateNodeDistributionCommand;

public class GetDistribution {
    private static final String FILE_NAME_GROUP = "fileName";
    private static final Pattern URL_FILENAME_PATTERN = Pattern.compile("^.*/(?<fileName>[^/]+)/*$");
    private final ResolveNodeDistributionUrl resolveNodeDistributionUrl;
    private final BuildTemporaryFileName buildTemporaryFileName;
    private final DownloadResource downloadResource;
    private final ValidateNodeDistribution validateNodeDistribution;
    private final Logger logger;

    public Path execute(GetDistributionCommand command) throws IOException, InvalidDistributionUrlException, ResourceDownloadException, InvalidNodeDistributionException, NodeDistributionShasumNotFoundException, UnsupportedPlatformException, URISyntaxException {
        ResolveNodeDistributionUrlCommand resolveNodeDistributionUrlCommand = new ResolveNodeDistributionUrlCommand(command.getPlatform(), command.getVersion(), command.getDistributionUrlRoot(), command.getDistributionUrlPathPattern());
        URL distributionUrl = this.resolveNodeDistributionUrl.execute(resolveNodeDistributionUrlCommand);
        this.logger.info("Downloading distribution at '{}'", distributionUrl);
        Path distributionFilePath = command.getTemporaryDirectoryPath().resolve(this.resolveDistributionFileName(distributionUrl));
        Path temporaryFilePath = command.getTemporaryDirectoryPath().resolve(this.buildTemporaryFileName.execute(distributionFilePath.getFileName().toString()));
        this.downloadResource.execute(DownloadResourceCommand.builder().resourceUrl(distributionUrl).serverCredentials(command.getDistributionServerCredentials()).proxySettings(command.getProxySettings()).retrySettings(command.getRetrySettings()).temporaryFilePath(temporaryFilePath).destinationFilePath(distributionFilePath).build());
        this.validateNodeDistribution.execute(ValidateNodeDistributionCommand.builder().temporaryDirectoryPath(command.getTemporaryDirectoryPath()).distributionUrl(distributionUrl).distributionServerCredentials(command.getDistributionServerCredentials()).proxySettings(command.getProxySettings()).retrySettings(command.getRetrySettings()).distributionFilePath(distributionFilePath).build());
        return distributionFilePath;
    }

    private String resolveDistributionFileName(URL distributionUrl) throws InvalidDistributionUrlException {
        String distributionUrlPath = distributionUrl.getPath();
        Matcher fileNameMatcher = URL_FILENAME_PATTERN.matcher(distributionUrlPath);
        if (!fileNameMatcher.matches()) {
            throw new InvalidDistributionUrlException(distributionUrl);
        }
        return fileNameMatcher.group(FILE_NAME_GROUP);
    }

    @Generated
    public GetDistribution(ResolveNodeDistributionUrl resolveNodeDistributionUrl, BuildTemporaryFileName buildTemporaryFileName, DownloadResource downloadResource, ValidateNodeDistribution validateNodeDistribution, Logger logger) {
        this.resolveNodeDistributionUrl = resolveNodeDistributionUrl;
        this.buildTemporaryFileName = buildTemporaryFileName;
        this.downloadResource = downloadResource;
        this.validateNodeDistribution = validateNodeDistribution;
        this.logger = logger;
    }
}

