/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.siouan.frontendgradleplugin.domain.installer.Credentials;
import org.siouan.frontendgradleplugin.domain.installer.HttpClient;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.LocalFileHttpResponse;

public abstract class AbstractHttpClient
implements HttpClient {
    @Override
    public HttpResponse sendGetRequest(URL resourceUrl, Credentials credentials, ProxySettings proxySettings) throws IOException {
        if (resourceUrl.getProtocol().equals("file")) {
            return this.getLocalResource(resourceUrl);
        }
        return this.getRemoteResource(resourceUrl, credentials, proxySettings);
    }

    private HttpResponse getLocalResource(URL resourceUrl) {
        try {
            return LocalFileHttpResponse.builder().localFilePath(Paths.get(resourceUrl.toURI())).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract HttpResponse getRemoteResource(URL var1, Credentials var2, ProxySettings var3) throws IOException;
}

