/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class StringSplitter {
    private final char separatorChar;
    private final char escapeChar;

    public List<String> execute(String arg) {
        ArrayList<String> tokens = new ArrayList<String>();
        char currentChar = '\u0000';
        int tokenStartIndex = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char previousChar;
            if (i == 0) {
                currentChar = previousChar = arg.charAt(i);
            } else {
                previousChar = currentChar;
                currentChar = arg.charAt(i);
            }
            String token = this.parseToken(arg, i, this.isValidSeparatorChar(currentChar, previousChar), tokenStartIndex);
            if (token == null) continue;
            if (!token.isEmpty()) {
                tokens.add(token);
            }
            tokenStartIndex = i + 1;
        }
        return tokens;
    }

    private boolean isValidSeparatorChar(char currentChar, char previousChar) {
        return currentChar == this.separatorChar && previousChar != this.escapeChar;
    }

    private String parseToken(String arg, int currentCharIndex, boolean validSeparator, int tokenStartIndex) {
        boolean tokenFound;
        boolean lastToken = currentCharIndex == arg.length() - 1;
        boolean bl = tokenFound = lastToken || validSeparator;
        if (!tokenFound) {
            return null;
        }
        String token = lastToken ? arg.substring(tokenStartIndex, validSeparator ? currentCharIndex : currentCharIndex + 1) : arg.substring(tokenStartIndex, currentCharIndex);
        return token.replace(String.valueOf(this.escapeChar) + this.separatorChar, String.valueOf(this.separatorChar));
    }

    @Generated
    public StringSplitter(char separatorChar, char escapeChar) {
        this.separatorChar = separatorChar;
        this.escapeChar = escapeChar;
    }
}

