/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.GetExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveCorepackExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveNpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolvePnpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveYarnExecutablePath;

public class GetExecutablePath {
    private final ResolveCorepackExecutablePath resolveCorepackExecutablePath;
    private final ResolveNodeExecutablePath resolveNodeExecutablePath;
    private final ResolveNpmExecutablePath resolveNpmExecutablePath;
    private final ResolvePnpmExecutablePath resolvePnpmExecutablePath;
    private final ResolveYarnExecutablePath resolveYarnExecutablePath;

    public Path execute(GetExecutablePathCommand command) {
        ResolveExecutablePathCommand resolveExecutablePathCommand = ResolveExecutablePathCommand.builder().platform(command.getPlatform()).nodeInstallDirectoryPath(command.getNodeInstallDirectoryPath()).build();
        return switch (command.getExecutableType()) {
            default -> throw new IncompatibleClassChangeError();
            case ExecutableType.COREPACK -> this.resolveCorepackExecutablePath.execute(resolveExecutablePathCommand);
            case ExecutableType.NODE -> this.resolveNodeExecutablePath.execute(resolveExecutablePathCommand);
            case ExecutableType.NPM -> this.resolveNpmExecutablePath.execute(resolveExecutablePathCommand);
            case ExecutableType.PNPM -> this.resolvePnpmExecutablePath.execute(resolveExecutablePathCommand);
            case ExecutableType.YARN -> this.resolveYarnExecutablePath.execute(resolveExecutablePathCommand);
        };
    }

    @Generated
    public GetExecutablePath(ResolveCorepackExecutablePath resolveCorepackExecutablePath, ResolveNodeExecutablePath resolveNodeExecutablePath, ResolveNpmExecutablePath resolveNpmExecutablePath, ResolvePnpmExecutablePath resolvePnpmExecutablePath, ResolveYarnExecutablePath resolveYarnExecutablePath) {
        this.resolveCorepackExecutablePath = resolveCorepackExecutablePath;
        this.resolveNodeExecutablePath = resolveNodeExecutablePath;
        this.resolveNpmExecutablePath = resolveNpmExecutablePath;
        this.resolvePnpmExecutablePath = resolvePnpmExecutablePath;
        this.resolveYarnExecutablePath = resolveYarnExecutablePath;
    }
}

