/*
 * Copyright © 2009 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataSource;
import lombok.Builder;
import lombok.Getter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

@Getter
@Builder
public class MimeDataSource implements Comparable<MimeDataSource> {
	private final String name;
	private final DataSource dataSource;
	@Nullable private final String contentDescription;
	@Nullable private final String contentTransferEncoding;

	@Override
	public int compareTo(@NotNull final MimeDataSource o) {
		int keyComparison = getName().compareTo(o.getName());
		if (keyComparison != 0) {
			return keyComparison;
		}
		return Integer.compare(getDataSource().hashCode(), o.getDataSource().hashCode());
	}

	@Override
	public boolean equals(final Object o) {
		return this == o ||
				(o instanceof MimeDataSource && compareTo((MimeDataSource) o) == 0);
	}

	@Override
	public int hashCode() {
		return Objects.hash(name, dataSource);
	}
}