/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.util;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public class MessageIdFixingMimeMessage
extends MimeMessage {
    @Nullable
    private final String messageId;

    public MessageIdFixingMimeMessage(Session session, @Nullable String messageId) {
        super(session);
        this.messageId = messageId;
    }

    protected void updateMessageID() throws MessagingException {
        if (MiscUtil.valueNullOrEmpty((Object)this.messageId)) {
            super.updateMessageID();
        } else {
            this.setHeader("Message-ID", this.messageId);
        }
    }

    public String toString() {
        try {
            return String.format("MimeMessage<id:%s, subject:%s>", super.getMessageID(), super.getSubject());
        }
        catch (MessagingException e) {
            throw new IllegalStateException("should not reach here");
        }
    }
}

