/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.simplejavamail.outlookmessageparser.model.OutlookMessageProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookRecipient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookRecipient.class);
    private static final String X500_ADDRESS_PATTERN = "/o=[^/]+/ou=[^/]+(?:/cn=[^/]+)*";
    private final Map<Integer, Object> properties = new TreeMap<Integer, Object>();
    private String name;
    private String address;
    private String x500Address;
    private boolean nameWasUsedAsAddress;

    public void setProperty(OutlookMessageProperty msgProp) {
        String name = msgProp.getClazz();
        Object value = msgProp.getData();
        if (name == null || value == null) {
            return;
        }
        name = name.intern();
        int mapiClass = -1;
        try {
            mapiClass = Integer.parseInt(name, 16);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Unexpected mapi class: {}", (Object)name, (Object)e);
        }
        if (mapiClass == 12291 || mapiClass == 14846 || mapiClass == 12289) {
            this.handleNameAddressProperty(mapiClass, (String)value);
        }
        this.properties.put(mapiClass, value);
    }

    private void handleNameAddressProperty(int mapiClass, String probablyNamePossiblyAddress) {
        if (mapiClass == 12289) {
            this.handleNameProperty(probablyNamePossiblyAddress);
        } else if (mapiClass == 12291 || mapiClass == 14846) {
            this.handleAddressProperty(probablyNamePossiblyAddress);
        }
    }

    private void handleNameProperty(String probablyNamePossiblyAddress) {
        this.setName(probablyNamePossiblyAddress);
        if (this.address == null && probablyNamePossiblyAddress.contains("@")) {
            this.setAddress(probablyNamePossiblyAddress);
            this.nameWasUsedAsAddress = true;
        }
    }

    private void handleAddressProperty(String probablyNamePossiblyAddress) {
        if (probablyNamePossiblyAddress.contains("@") && (this.address == null || this.nameWasUsedAsAddress || this.address.matches(X500_ADDRESS_PATTERN))) {
            this.setAddress(probablyNamePossiblyAddress);
            this.nameWasUsedAsAddress = false;
        } else if (probablyNamePossiblyAddress.matches(X500_ADDRESS_PATTERN)) {
            if (this.address == null) {
                this.setAddress(probablyNamePossiblyAddress);
            }
            this.setX500Address(probablyNamePossiblyAddress);
            this.nameWasUsedAsAddress = false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlookRecipient that = (OutlookRecipient)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.x500Address, that.x500Address) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.x500Address, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (sb.length() > 0) {
            sb.append(" ");
        }
        if (this.address != null && !this.address.isEmpty()) {
            sb.append("<").append(this.address).append(">");
        }
        if (this.x500Address != null && !this.x500Address.isEmpty()) {
            sb.append("<").append(this.x500Address).append(">");
        }
        return sb.toString();
    }

    public Set<Integer> getPropertyCodes() {
        return this.properties.keySet();
    }

    public String getAddress() {
        return this.address;
    }

    public String getX500Address() {
        return this.x500Address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setX500Address(String x500Address) {
        this.x500Address = x500Address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }
}

