/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.dkimsupport;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.email.config.DkimConfig;
import org.simplejavamail.internal.dkimsupport.DKIMSigningException;
import org.simplejavamail.internal.dkimsupport.DkimMessageIdFixingMimeMessage;
import org.simplejavamail.internal.modules.DKIMModule;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.utils.mail.dkim.Canonicalization;
import org.simplejavamail.utils.mail.dkim.DkimSigner;
import org.simplejavamail.utils.mail.dkim.SigningAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DKIMSigner
implements DKIMModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DKIMSigner.class);

    public MimeMessage signMessageWithDKIM(@NotNull Email email, @NotNull MimeMessage messageToSign, @NotNull DkimConfig dkimConfig, @NotNull Recipient fromRecipient) {
        LOGGER.debug("signing MimeMessage with DKIM...");
        try {
            DkimSigner dkimSigner = new DkimSigner(dkimConfig.getDkimSigningDomain(), dkimConfig.getDkimSelector(), (InputStream)new ByteArrayInputStream(dkimConfig.getDkimPrivateKeyData()));
            ((Set)MiscUtil.defaultTo((Object)dkimConfig.getExcludedHeadersFromDkimDefaultSigningList(), Collections.emptySet())).forEach(arg_0 -> ((DkimSigner)dkimSigner).removeHeaderToSign(arg_0));
            dkimSigner.setIdentity(fromRecipient.getAddress());
            dkimSigner.setHeaderCanonicalization(DKIMSigner.mapToNativeCanonicalization((DkimConfig.Canonicalization)MiscUtil.defaultTo((Object)dkimConfig.getHeaderCanonicalization(), (Object)DkimConfig.Canonicalization.RELAXED)));
            dkimSigner.setBodyCanonicalization(DKIMSigner.mapToNativeCanonicalization((DkimConfig.Canonicalization)MiscUtil.defaultTo((Object)dkimConfig.getBodyCanonicalization(), (Object)DkimConfig.Canonicalization.RELAXED)));
            dkimSigner.setSigningAlgorithm(SigningAlgorithm.valueOf((String)((String)MiscUtil.defaultTo((Object)dkimConfig.getSigningAlgorithm(), (Object)SigningAlgorithm.SHA256_WITH_RSA.name()))));
            dkimSigner.setLengthParam(((Boolean)MiscUtil.defaultTo((Object)dkimConfig.getUseLengthParam(), (Object)false)).booleanValue());
            dkimSigner.setZParam(false);
            if (fromRecipient.getAddress().endsWith("supersecret-testing-domain.com")) {
                dkimSigner.setCheckDomainKey(false);
            }
            return new DkimMessageIdFixingMimeMessage(messageToSign, dkimSigner, email.getId());
        }
        catch (MessagingException | IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new DKIMSigningException("Error signing MimeMessage with DKIM", (Exception)e);
        }
    }

    private static Canonicalization mapToNativeCanonicalization(DkimConfig.Canonicalization canonicalization) {
        return canonicalization == DkimConfig.Canonicalization.SIMPLE ? Canonicalization.SIMPLE : Canonicalization.RELAXED;
    }

    public boolean isMessageIdFixingMessage(MimeMessage message) {
        return message instanceof DkimMessageIdFixingMimeMessage;
    }
}

