/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EqualsHelper;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.email.config.DkimConfig;
import org.simplejavamail.api.internal.smimesupport.model.PlainSmimeDetails;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.internal.config.EmailProperty;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class Email
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private final boolean ignoreDefaults;
    private final boolean ignoreOverrides;
    private final Set<EmailProperty> propertiesNotToApplyDefaultValueFor;
    private final Set<EmailProperty> propertiesNotToApplyOverrideValueFor;
    protected String id;
    private final Recipient fromRecipient;
    @NotNull
    private final List<Recipient> replyToRecipients;
    private final Recipient bounceToRecipient;
    private final String text;
    private final String textHTML;
    private final CalendarMethod calendarMethod;
    private final String textCalendar;
    @Nullable
    private final ContentTransferEncoding contentTransferEncoding;
    private final String subject;
    @NotNull
    private final List<Recipient> recipients;
    @NotNull
    private final List<AttachmentResource> embeddedImages;
    @NotNull
    private final List<AttachmentResource> attachments;
    @NotNull
    private final List<AttachmentResource> decryptedAttachments;
    @NotNull
    private final Map<String, Collection<String>> headers;
    @Nullable
    private final Boolean useDispositionNotificationTo;
    private final Recipient dispositionNotificationTo;
    @Nullable
    private final Boolean useReturnReceiptTo;
    private final Recipient returnReceiptTo;
    private final transient MimeMessage emailToForward;
    private final DkimConfig dkimConfig;
    private final X509Certificate x509CertificateForSmimeEncryption;
    private final transient Pkcs12Config pkcs12ConfigForSmimeSigning;
    private final Email smimeSignedEmail;
    @NotNull
    private final OriginalSmimeDetails originalSmimeDetails;
    protected final boolean wasMergedWithSmimeSignedMessage;
    @Nullable
    private final Date sentDate;

    public Email(@NotNull EmailPopulatingBuilder builder) {
        boolean smimeMerge;
        Preconditions.checkNonEmptyArgument(builder, "builder");
        this.ignoreDefaults = builder.isIgnoreDefaults();
        this.ignoreOverrides = builder.isIgnoreOverrides();
        this.propertiesNotToApplyDefaultValueFor = builder.getPropertiesNotToApplyDefaultValueFor();
        this.propertiesNotToApplyOverrideValueFor = builder.getPropertiesNotToApplyOverrideValueFor();
        this.smimeSignedEmail = builder.getSmimeSignedEmail();
        this.wasMergedWithSmimeSignedMessage = smimeMerge = builder.isMergeSingleSMIMESignedAttachment() && this.smimeSignedEmail != null;
        this.recipients = Collections.unmodifiableList(builder.getRecipients());
        this.embeddedImages = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getEmbeddedImages(), this.smimeSignedEmail.getEmbeddedImages()) : builder.getEmbeddedImages());
        this.attachments = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getAttachments(), this.smimeSignedEmail.getAttachments()) : builder.getAttachments());
        this.decryptedAttachments = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getDecryptedAttachments(), this.smimeSignedEmail.getDecryptedAttachments()) : builder.getDecryptedAttachments());
        this.headers = Collections.unmodifiableMap(smimeMerge ? ListUtil.merge(builder.getHeaders(), this.smimeSignedEmail.getHeaders()) : builder.getHeaders());
        this.id = builder.getId();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipients = Collections.unmodifiableList(builder.getReplyToRecipients());
        this.bounceToRecipient = builder.getBounceToRecipient();
        this.text = smimeMerge ? this.smimeSignedEmail.getPlainText() : builder.getText();
        this.textHTML = smimeMerge ? this.smimeSignedEmail.getHTMLText() : builder.getTextHTML();
        this.calendarMethod = builder.getCalendarMethod();
        this.textCalendar = builder.getTextCalendar();
        this.contentTransferEncoding = builder.getContentTransferEncoding();
        this.subject = builder.getSubject();
        this.useDispositionNotificationTo = builder.getUseDispositionNotificationTo();
        this.dispositionNotificationTo = builder.getDispositionNotificationTo();
        this.useReturnReceiptTo = builder.getUseReturnReceiptTo();
        this.returnReceiptTo = builder.getReturnReceiptTo();
        this.emailToForward = builder.getEmailToForward();
        this.originalSmimeDetails = builder.getOriginalSmimeDetails();
        this.sentDate = builder.getSentDate();
        this.x509CertificateForSmimeEncryption = builder.getX509CertificateForSmimeEncryption();
        this.pkcs12ConfigForSmimeSigning = builder.getPkcs12ConfigForSmimeSigning();
        this.dkimConfig = builder.getDkimConfig();
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        String s = "Email{\n\tid=" + this.id + "\n\tsentDate=" + this.formatDate(this.sentDate) + "\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipients=" + this.replyToRecipients + ",\n\tbounceToRecipient=" + this.bounceToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\ttextCalendar='" + String.format("%s (method: %s)", new Object[]{this.textCalendar, this.calendarMethod}) + '\'' + ",\n\tcontentTransferEncoding='" + (Object)((Object)(this.contentTransferEncoding != null ? this.contentTransferEncoding : ContentTransferEncoding.getDefault())) + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients;
        if (!MiscUtil.valueNullOrEmpty(this.dkimConfig)) {
            s = s + ",\n\tdkimConfig=" + this.dkimConfig;
        }
        if (Boolean.TRUE.equals(this.useDispositionNotificationTo)) {
            s = s + ",\n\tuseDispositionNotificationTo=true,\n\t\tdispositionNotificationTo=" + this.dispositionNotificationTo;
        }
        if (Boolean.TRUE.equals(this.useReturnReceiptTo)) {
            s = s + ",\n\tuseReturnReceiptTo=true,\n\t\treturnReceiptTo=" + this.returnReceiptTo;
        }
        if (!this.headers.isEmpty()) {
            s = s + ",\n\theaders=" + this.headers;
        }
        if (!this.embeddedImages.isEmpty()) {
            s = s + ",\n\tembeddedImages=" + this.embeddedImages;
        }
        if (!this.attachments.isEmpty()) {
            s = s + ",\n\tattachments=" + this.attachments;
        }
        if (!this.decryptedAttachments.isEmpty()) {
            s = s + ",\n\tdecryptedAttachments=" + this.decryptedAttachments;
        }
        if (this.emailToForward != null) {
            s = s + ",\n\tforwardingEmail=true";
        }
        if (this.smimeSignedEmail != null || this.pkcs12ConfigForSmimeSigning != null || this.x509CertificateForSmimeEncryption != null || !(this.originalSmimeDetails instanceof PlainSmimeDetails)) {
            s = s + ",\n\tsmime details: {\n";
            s = s + "\t----------------------\n";
            if (this.smimeSignedEmail != null) {
                s = s + "\t\tsmimeSignedEmail=" + this.smimeSignedEmail + ",\n";
            }
            if (this.pkcs12ConfigForSmimeSigning != null) {
                s = s + "\t\tpkcs12ConfigForSmimeSigning=" + this.pkcs12ConfigForSmimeSigning + ",\n";
            }
            if (this.x509CertificateForSmimeEncryption != null) {
                s = s + "\t\tx509CertificateForSmimeEncryption=" + this.x509CertificateForSmimeEncryption;
            }
            s = s + "\t\toriginalSmimeDetails=" + this.originalSmimeDetails + "\n";
            s = s + "\t----------------------\n\t}";
        }
        s = s + "\n}";
        return s;
    }

    @Nullable
    private String formatDate(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public boolean isIgnoreDefaults() {
        return this.ignoreDefaults;
    }

    public boolean isIgnoreOverrides() {
        return this.ignoreOverrides;
    }

    @Nullable
    public Set<EmailProperty> getPropertiesNotToApplyDefaultValueFor() {
        return this.propertiesNotToApplyDefaultValueFor;
    }

    @Nullable
    public Set<EmailProperty> getPropertiesNotToApplyOverrideValueFor() {
        return this.propertiesNotToApplyOverrideValueFor;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    @NotNull
    public List<Recipient> getReplyToRecipients() {
        return this.replyToRecipients;
    }

    @Nullable
    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public Boolean getUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    @Nullable
    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    @Nullable
    public Boolean getUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    @Nullable
    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    @Nullable
    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }

    @Nullable
    public String getPlainText() {
        return this.text;
    }

    @Nullable
    public String getHTMLText() {
        return this.textHTML;
    }

    @Nullable
    public CalendarMethod getCalendarMethod() {
        return this.calendarMethod;
    }

    @Nullable
    public String getCalendarText() {
        return this.textCalendar;
    }

    @NotNull
    public List<AttachmentResource> getAttachments() {
        return this.attachments;
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        return this.decryptedAttachments;
    }

    @NotNull
    public List<AttachmentResource> getEmbeddedImages() {
        return this.embeddedImages;
    }

    @NotNull
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public List<Recipient> getToRecipients() {
        return this.recipients.stream().filter(r -> r.getType() == Message.RecipientType.TO).collect(Collectors.toList());
    }

    @NotNull
    public List<Recipient> getCcRecipients() {
        return this.recipients.stream().filter(r -> r.getType() == Message.RecipientType.CC).collect(Collectors.toList());
    }

    @NotNull
    public List<Recipient> getBccRecipients() {
        return this.recipients.stream().filter(r -> r.getType() == Message.RecipientType.BCC).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public DkimConfig getDkimConfig() {
        return this.dkimConfig;
    }

    @Nullable
    public X509Certificate getX509CertificateForSmimeEncryption() {
        return this.x509CertificateForSmimeEncryption;
    }

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Nullable
    public Email getSmimeSignedEmail() {
        return this.smimeSignedEmail;
    }

    @NotNull
    public OriginalSmimeDetails getOriginalSmimeDetails() {
        return this.originalSmimeDetails;
    }

    @Nullable
    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }

    @Nullable
    public ContentTransferEncoding getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }
}

