/*
 * Copyright © 2009 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simplejavamail.api.email;

/**
 * Since defaults and overrides are not applied all the way in the beginning anymore when creating an Email instance, at the time of sending we want to
 * double-check that defaults and overrides are applied by that time at least. Making this a compile-time check proved to be very cumbersome and confusing
 * to the user, so finally we opted for a runtime check behind the scenes.
 */
public interface EmailWithDefaultsAndOverridesApplied {
    void markAsDefaultsAndOverridesApplied();
    void verifyDefaultsAndOverridesApplied();
}