/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util.concurrent;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedRunnable.class);
    @NotNull
    private final String processName;
    @NotNull
    private final Runnable operation;

    @Override
    public void run() {
        try {
            this.operation.run();
        }
        catch (Exception e) {
            LOGGER.error("Failed to run " + this.processName, (Throwable)e);
            throw e;
        }
    }

    public String toString() {
        return this.processName;
    }

    @Generated
    public NamedRunnable(@NotNull String processName, @NotNull Runnable operation) {
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.processName = processName;
        this.operation = operation;
    }
}

