/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class FileUtil {
    public static String readFileContent(@NotNull File file) throws IOException {
        return new String(FileUtil.readFileBytes(file), StandardCharsets.UTF_8);
    }

    public static byte[] readFileBytes(@NotNull File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File not found: %s", file));
        }
        return Files.readAllBytes(file.toPath());
    }

    public static void writeFileBytes(@NotNull File file, byte[] bytes) throws IOException {
        try {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        Files.write(file.toPath(), bytes, new OpenOption[0]);
    }
}

