/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.clisupport.model;

import java.util.Arrays;
import java.util.List;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.StringUtil;

public class CliDeclaredOptionValue {
    private final String name;
    private final String helpLabel;
    private final String description;
    private final boolean required;
    private final String[] examples;

    public CliDeclaredOptionValue(String name, String helpLabel, String description, boolean required, String[] examples) {
        this.name = name;
        this.helpLabel = helpLabel;
        this.description = description;
        this.required = required;
        this.examples = (String[])examples.clone();
    }

    public String formatDescription() {
        if (this.examples.length == 0) {
            return this.description;
        }
        if (this.examples.length == 1) {
            return this.description + "\n    example: " + this.examples[0];
        }
        return this.description + "\n    examples: " + CliDeclaredOptionValue.formatExamplesText("    examples: ".length(), Arrays.asList(this.examples));
    }

    private static String formatExamplesText(int indent, List<String> examples) {
        StringBuilder examplesFormatted = new StringBuilder().append(ListUtil.getFirst(examples)).append("\n");
        for (String example : examples.subList(1, examples.size())) {
            examplesFormatted.append(StringUtil.nStrings(indent, " ")).append(example).append("\n");
        }
        return examplesFormatted.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getHelpLabel() {
        return this.helpLabel;
    }

    public boolean isRequired() {
        return this.required;
    }
}

