/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.util.Preconditions;

public class StringUtil {
    public static String nStrings(int n, String str) {
        if (str == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/StringUtil.nStrings must not be null");
        }
        String string = new String(new char[n]).replace("\u0000", str);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/StringUtil.nStrings must not return null");
        }
        return string;
    }

    @NotNull
    public static String replaceNestedTokens(String lineWithTokens, int nestingDepth, String tokenOpen, String tokenClose, String tokenRegexToReplace, StringFormatter tokenReplacer) {
        if (lineWithTokens == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not be null");
        }
        if (tokenOpen == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not be null");
        }
        if (tokenClose == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not be null");
        }
        if (tokenRegexToReplace == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 4 of org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not be null");
        }
        if (tokenReplacer == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 5 of org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not be null");
        }
        Pattern startsWithOpen = Pattern.compile(Pattern.quote(tokenOpen));
        Pattern startsWithClose = Pattern.compile(Pattern.quote(tokenClose));
        Pattern startsWithTokenToReplace = Pattern.compile(String.format("(?<token>%s)", tokenRegexToReplace));
        StringBuilder lineWithTokensReplaced = new StringBuilder();
        int countOpenTokens = 0;
        int pos = 0;
        while (pos < lineWithTokens.length()) {
            String remainingLine = lineWithTokens.substring(pos);
            if (startsWithOpen.matcher(remainingLine).lookingAt()) {
                ++countOpenTokens;
                lineWithTokensReplaced.append(tokenOpen);
                pos += tokenOpen.length();
            } else if (startsWithClose.matcher(remainingLine).lookingAt()) {
                --countOpenTokens;
                lineWithTokensReplaced.append(tokenClose);
                pos += tokenClose.length();
            } else if (countOpenTokens == nestingDepth) {
                Matcher startsWithTokenMatcher = startsWithTokenToReplace.matcher(remainingLine);
                if (startsWithTokenMatcher.lookingAt()) {
                    String matchedToken = startsWithTokenMatcher.group("token");
                    lineWithTokensReplaced.append(tokenReplacer.apply(matchedToken));
                    pos += matchedToken.length();
                } else {
                    lineWithTokensReplaced.append(lineWithTokens.charAt(pos++));
                }
            } else {
                lineWithTokensReplaced.append(lineWithTokens.charAt(pos++));
            }
            Preconditions.assumeTrue(countOpenTokens >= 0, "Unbalanced token sets: closed token without open token\n\t" + lineWithTokens);
        }
        Preconditions.assumeTrue(countOpenTokens == 0, "Unbalanced token sets: open token without closed token\n\t" + lineWithTokens);
        String string = lineWithTokensReplaced.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/StringUtil.replaceNestedTokens must not return null");
        }
        return string;
    }

    public static String padRight(String s, int n) {
        if (s == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/StringUtil.padRight must not be null");
        }
        String string = String.format("%1$-" + n + "s", s);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/StringUtil.padRight must not return null");
        }
        return string;
    }

    public static class StringFormatter {
        private final String formatPattern;

        public static StringFormatter formatterForPattern(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/StringUtil$StringFormatter.formatterForPattern must not be null");
            }
            StringFormatter stringFormatter = new StringFormatter(pattern);
            if (stringFormatter == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/StringUtil$StringFormatter.formatterForPattern must not return null");
            }
            return stringFormatter;
        }

        private StringFormatter(String formatPattern) {
            if (formatPattern == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/StringUtil$StringFormatter.<init> must not be null");
            }
            this.formatPattern = formatPattern;
        }

        String apply(String input) {
            if (input == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/StringUtil$StringFormatter.apply must not be null");
            }
            String string = String.format(this.formatPattern, input);
            if (string == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/StringUtil$StringFormatter.apply must not return null");
            }
            return string;
        }
    }
}

