/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.Preconditions;

public final class MiscUtil {
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile("(@.*?>?)\\s*[,;]");
    private static final Pattern TRAILING_TOKEN_DELIMITER_PATTERN = Pattern.compile("<\\|>$");
    private static final Pattern TOKEN_DELIMITER_PATTERN = Pattern.compile("\\s*<\\|>\\s*");

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public static <T> T checkNotNull(@Nullable T value, @Nullable String msg) {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        T t = value;
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.checkNotNull must not return null");
        }
        return t;
    }

    public static <T> T checkArgumentNotEmpty(@Nullable T value, @Nullable String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        T t = value;
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.checkArgumentNotEmpty must not return null");
        }
        return t;
    }

    public static <T> boolean valueNullOrEmpty(@Nullable T value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof byte[] && ((byte[])value).length == 0;
    }

    public static String buildLogStringForSOCKSCommunication(byte[] bytes, boolean isReceived) {
        if (bytes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.buildLogStringForSOCKSCommunication must not be null");
        }
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        String string = debugMsg.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.buildLogStringForSOCKSCommunication must not return null");
        }
        return string;
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    @Nullable
    public static String encodeText(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)name, (String)StandardCharsets.UTF_8.name(), (String)"B");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nullable
    public static String extractCID(@Nullable String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }

    @NotNull
    public static String readInputStreamToString(@NotNull InputStream inputStream, @NotNull Charset charset) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.readInputStreamToString must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/MiscUtil.readInputStreamToString must not be null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        String string = byteArrayOutputStream.toString(Preconditions.checkNonEmptyArgument(charset, "charset").name());
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.readInputStreamToString must not return null");
        }
        return string;
    }

    @NotNull
    public static byte[] readInputStreamToBytes(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.readInputStreamToBytes must not be null");
        }
        byte[] targetArray = new byte[inputStream.available()];
        inputStream.read(targetArray);
        if (targetArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.readInputStreamToBytes must not return null");
        }
        return targetArray;
    }

    @NotNull
    public static String[] extractEmailAddresses(@NotNull String emailAddressList) {
        if (emailAddressList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.extractEmailAddresses must not be null");
        }
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        String unambiguousDelimitedList = COMMA_DELIMITER_PATTERN.matcher(emailAddressList).replaceAll("$1<|>");
        String withoutTrailingDelimeter = TRAILING_TOKEN_DELIMITER_PATTERN.matcher(unambiguousDelimitedList).replaceAll("");
        String[] stringArray = TOKEN_DELIMITER_PATTERN.split(withoutTrailingDelimeter, 0);
        if (stringArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.extractEmailAddresses must not return null");
        }
        return stringArray;
    }

    @NotNull
    public static Recipient interpretRecipient(@Nullable String name, boolean fixedName, @NotNull String emailAddress, @Nullable Message.RecipientType type) {
        if (emailAddress == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/internal/util/MiscUtil.interpretRecipient must not be null");
        }
        try {
            InternetAddress parsedAddress = InternetAddress.parse((String)emailAddress, (boolean)false)[0];
            String relevantName = fixedName || parsedAddress.getPersonal() == null ? MiscUtil.defaultTo(name, parsedAddress.getPersonal()) : MiscUtil.defaultTo(parsedAddress.getPersonal(), name);
            Recipient recipient = new Recipient(relevantName, parsedAddress.getAddress(), type);
            if (recipient == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.interpretRecipient must not return null");
            }
            return recipient;
        }
        catch (AddressException e) {
            Recipient recipient = new Recipient(name, emailAddress, type);
            if (recipient == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.interpretRecipient must not return null");
            }
            return recipient;
        }
    }

    @Nullable
    public static <T> T defaultTo(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean classAvailable(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.classAvailable must not be null");
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static <T1, T2> Map.Entry<T1, T2>[] zip(T1[] zipLeft, T2[] zipRight) {
        if (zipLeft == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.zip must not be null");
        }
        if (zipRight == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/MiscUtil.zip must not be null");
        }
        Map.Entry[] entryArray = MiscUtil.zip(Arrays.asList(zipLeft), Arrays.asList(zipRight)).toArray(new Map.Entry[0]);
        if (entryArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.zip must not return null");
        }
        return entryArray;
    }

    public static <T1, T2> List<Map.Entry<T1, T2>> zip(List<T1> zipLeft, List<T2> zipRight) {
        if (zipLeft == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.zip must not be null");
        }
        if (zipRight == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/MiscUtil.zip must not be null");
        }
        Preconditions.assumeTrue(zipLeft.size() == zipRight.size(), "Can't zip lists, sizes are not equals");
        ArrayList<Map.Entry<T1, T2>> zipped = new ArrayList<Map.Entry<T1, T2>>();
        for (int i = 0; i < zipLeft.size(); ++i) {
            zipped.add(new AbstractMap.SimpleEntry<T1, T2>(zipLeft.get(i), zipRight.get(i)));
        }
        ArrayList<Map.Entry<T1, T2>> arrayList = zipped;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.zip must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static String normalizeNewlines(@Nullable String text) {
        return text == null ? null : text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
    }

    public static int countMandatoryParameters(@NotNull Method m) {
        if (m == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.countMandatoryParameters must not be null");
        }
        int mandatoryParameterCount = 0;
        for (Annotation[] annotations : m.getParameterAnnotations()) {
            mandatoryParameterCount += !MiscUtil.containsNullableAnnotation(annotations) ? 1 : 0;
        }
        return mandatoryParameterCount;
    }

    private static boolean containsNullableAnnotation(Annotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.containsNullableAnnotation must not be null");
        }
        for (Annotation annotation : (Annotation[])annotations.clone()) {
            if (annotation.annotationType() != Nullable.class) continue;
            return true;
        }
        return false;
    }

    public static String readFileContent(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.readFileContent must not be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File not found: %s", file));
        }
        String string = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.readFileContent must not return null");
        }
        return string;
    }

    public static boolean inputStreamEqual(InputStream inputOrg1, InputStream inputOrg2) {
        int ch2;
        if (inputOrg1 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.inputStreamEqual must not be null");
        }
        if (inputOrg2 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/MiscUtil.inputStreamEqual must not be null");
        }
        ByteArrayInputStream input1 = MiscUtil.copyInputstream(inputOrg1);
        ByteArrayInputStream input2 = MiscUtil.copyInputstream(inputOrg2);
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static ByteArrayInputStream copyInputstream(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/MiscUtil.copyInputstream must not be null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            if (input instanceof FileInputStream) {
                ((FileInputStream)input).getChannel().position(0L);
            } else {
                input.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
        if (byteArrayInputStream == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/MiscUtil.copyInputstream must not return null");
        }
        return byteArrayInputStream;
    }
}

