/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.MailException;
import org.simplejavamail.internal.util.MiscUtil;

public class CertificationUtil {
    private static final String BOUNCY_CASTLE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static X509Certificate readFromPem(File pemFile) throws CertificateException, NoSuchProviderException, FileNotFoundException {
        if (pemFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/CertificationUtil.readFromPem must not be null");
        }
        X509Certificate x509Certificate = CertificationUtil.readFromPem(new FileInputStream(pemFile));
        if (x509Certificate == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/CertificationUtil.readFromPem must not return null");
        }
        return x509Certificate;
    }

    public static X509Certificate readFromPem(InputStream pemData) throws CertificateException, NoSuchProviderException {
        if (pemData == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/CertificationUtil.readFromPem must not be null");
        }
        if (MiscUtil.classAvailable(BOUNCY_CASTLE_PROVIDER_CLASS)) {
            try {
                Class<Provider> bouncyCastleClass = Class.forName(BOUNCY_CASTLE_PROVIDER_CLASS);
                Security.addProvider(CertificationUtil.getProvider(bouncyCastleClass));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)String.format("Class found but also not found??? (%s)", BOUNCY_CASTLE_PROVIDER_CLASS));
            }
        } else {
            throw new SmimeSupportMissingException();
        }
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(pemData);
        if (x509Certificate == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/CertificationUtil.readFromPem must not return null");
        }
        return x509Certificate;
    }

    @NotNull
    private static Provider getProvider(Class<Provider> bouncyCastleClass) {
        Provider provider;
        if (bouncyCastleClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/CertificationUtil.getProvider must not be null");
        }
        try {
            provider = bouncyCastleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
        if (provider == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/CertificationUtil.getProvider must not return null");
        }
        return provider;
    }

    private static class SmimeSupportMissingException
    extends MailException {
        SmimeSupportMissingException() {
            super("Can't read x509 certificate from PEM file (missing BouncyCastle Provider). Is the S/MIME module on the class path?");
        }
    }
}

