/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer.config;

import java.util.Properties;
import javax.mail.Session;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TransportStrategy {
    SMTP{
        private static final int DEFAULT_SMTP_PORT = 25;
        private static final boolean DEFAULT_OPPORTUNISTIC_TLS = true;
        @Nullable
        private Boolean opportunisticTLS;

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            if (Preconditions.assumeNonNull(ConfigLoader.valueOrPropertyAsBoolean(this.opportunisticTLS, ConfigLoader.Property.OPPORTUNISTIC_TLS, true)).booleanValue()) {
                LOGGER.debug("Opportunistic TLS mode enabled for SMTP plain protocol.");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.required", "false");
            }
            Properties properties = props;
            if (properties == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.generateProperties must not return null");
            }
            return properties;
        }

        @Override
        public String propertyNameHost() {
            if ("mail.smtp.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameHost must not return null");
            }
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            if ("mail.smtp.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNamePort must not return null");
            }
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            if ("mail.smtp.username" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameUsername must not return null");
            }
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            if ("mail.smtp.auth" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameAuthenticate must not return null");
            }
            return "mail.smtp.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            if ("mail.smtp.socks.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameSocksHost must not return null");
            }
            return "mail.smtp.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            if ("mail.smtp.socks.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameSocksPort must not return null");
            }
            return "mail.smtp.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            if ("mail.smtp.connectiontimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameConnectionTimeout must not return null");
            }
            return "mail.smtp.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            if ("mail.smtp.timeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameTimeout must not return null");
            }
            return "mail.smtp.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            if ("mail.smtp.writetimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameWriteTimeout must not return null");
            }
            return "mail.smtp.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            if ("mail.smtp.from" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameEnvelopeFrom must not return null");
            }
            return "mail.smtp.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            if ("mail.smtp.ssl.trust" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$1.propertyNameSSLTrust must not return null");
            }
            return "mail.smtp.ssl.trust";
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            throw new AssertionError((Object)"This property is not relevant for plain SMTP");
        }

        @Override
        public void setOpportunisticTLS(@Nullable Boolean opportunisticTLS) {
            this.opportunisticTLS = opportunisticTLS;
        }

        @Override
        public int getDefaultServerPort() {
            return 25;
        }
    }
    ,
    SMTPS{
        private static final int DEFAULT_SMTPS_PORT = 465;

        @Override
        public Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.put("mail.transport.protocol", "smtps");
            properties.put("mail.smtps.quitwait", "false");
            Properties properties2 = properties;
            if (properties2 == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.generateProperties must not return null");
            }
            return properties2;
        }

        @Override
        public String propertyNameHost() {
            if ("mail.smtps.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameHost must not return null");
            }
            return "mail.smtps.host";
        }

        @Override
        public String propertyNamePort() {
            if ("mail.smtps.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNamePort must not return null");
            }
            return "mail.smtps.port";
        }

        @Override
        public String propertyNameUsername() {
            if ("mail.smtps.username" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameUsername must not return null");
            }
            return "mail.smtps.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            if ("mail.smtps.auth" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameAuthenticate must not return null");
            }
            return "mail.smtps.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            if ("mail.smtps.socks.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameSocksHost must not return null");
            }
            return "mail.smtps.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            if ("mail.smtps.socks.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameSocksPort must not return null");
            }
            return "mail.smtps.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            if ("mail.smtps.connectiontimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameConnectionTimeout must not return null");
            }
            return "mail.smtps.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            if ("mail.smtps.timeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameTimeout must not return null");
            }
            return "mail.smtps.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            if ("mail.smtps.writetimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameWriteTimeout must not return null");
            }
            return "mail.smtps.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            if ("mail.smtps.from" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameEnvelopeFrom must not return null");
            }
            return "mail.smtps.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            if ("mail.smtps.ssl.trust" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameSSLTrust must not return null");
            }
            return "mail.smtps.ssl.trust";
        }

        @Override
        public int getDefaultServerPort() {
            return 465;
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            if ("mail.smtps.ssl.checkserveridentity" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$2.propertyNameCheckServerIdentity must not return null");
            }
            return "mail.smtps.ssl.checkserveridentity";
        }
    }
    ,
    SMTP_TLS{
        private static final int DEFAULT_SMTP_TLS_PORT = 587;

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
            Properties properties = props;
            if (properties == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.generateProperties must not return null");
            }
            return properties;
        }

        @Override
        public String propertyNameHost() {
            if ("mail.smtp.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameHost must not return null");
            }
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            if ("mail.smtp.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNamePort must not return null");
            }
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            if ("mail.smtp.username" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameUsername must not return null");
            }
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            if ("mail.smtp.auth" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameAuthenticate must not return null");
            }
            return "mail.smtp.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            if ("mail.smtp.socks.host" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameSocksHost must not return null");
            }
            return "mail.smtp.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            if ("mail.smtp.socks.port" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameSocksPort must not return null");
            }
            return "mail.smtp.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            if ("mail.smtp.connectiontimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameConnectionTimeout must not return null");
            }
            return "mail.smtp.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            if ("mail.smtp.timeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameTimeout must not return null");
            }
            return "mail.smtp.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            if ("mail.smtp.writetimeout" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameWriteTimeout must not return null");
            }
            return "mail.smtp.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            if ("mail.smtp.from" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameEnvelopeFrom must not return null");
            }
            return "mail.smtp.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            if ("mail.smtp.ssl.trust" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameSSLTrust must not return null");
            }
            return "mail.smtp.ssl.trust";
        }

        @Override
        public int getDefaultServerPort() {
            return 587;
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            if ("mail.smtp.ssl.checkserveridentity" == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy$3.propertyNameCheckServerIdentity must not return null");
            }
            return "mail.smtp.ssl.checkserveridentity";
        }
    };

    private static final Logger LOGGER;
    private static final String TRANSPORT_STRATEGY_MARKER = "simplejavamail.transportstrategy";

    private TransportStrategy() {
        if (string == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/TransportStrategy.<init> must not be null");
        }
    }

    public Properties generateProperties() {
        Properties properties = new Properties();
        properties.put(TRANSPORT_STRATEGY_MARKER, this.name());
        Properties properties2 = properties;
        if (properties2 == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy.generateProperties must not return null");
        }
        return properties2;
    }

    public abstract String propertyNameHost();

    public abstract String propertyNamePort();

    public abstract String propertyNameUsername();

    public abstract String propertyNameAuthenticate();

    public abstract String propertyNameSocksHost();

    public abstract String propertyNameSocksPort();

    public abstract String propertyNameConnectionTimeout();

    public abstract String propertyNameWriteTimeout();

    public abstract String propertyNameTimeout();

    public abstract String propertyNameEnvelopeFrom();

    public abstract String propertyNameSSLTrust();

    public abstract String propertyNameCheckServerIdentity();

    public abstract int getDefaultServerPort();

    public void setOpportunisticTLS(@Nullable Boolean opportunisticTLS) {
    }

    @Nullable
    public static TransportStrategy findStrategyForSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/TransportStrategy.findStrategyForSession must not be null");
        }
        String transportStrategyMarker = session.getProperty(TRANSPORT_STRATEGY_MARKER);
        if (transportStrategyMarker != null) {
            return TransportStrategy.valueOf(transportStrategyMarker);
        }
        return null;
    }

    public String toString(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/TransportStrategy.toString must not be null");
        }
        String string = String.format("session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)", new Object[]{properties.get(this.propertyNameHost()), properties.get(this.propertyNamePort()), properties.get(this.propertyNameUsername()), properties.get(this.propertyNameAuthenticate()), this});
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/TransportStrategy.toString must not return null");
        }
        return string;
    }

    static {
        LOGGER = LoggerFactory.getLogger(TransportStrategy.class);
    }
}

