/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.activation.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.EqualsHelper;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class AttachmentResource
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private final String name;
    private final transient DataSource dataSource;

    public AttachmentResource(@Nullable String name, @NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/email/AttachmentResource.<init> must not be null");
        }
        this.name = name;
        this.dataSource = Preconditions.checkNonEmptyArgument(dataSource, "dataSource");
    }

    @NotNull
    public String readAllData() throws IOException {
        String string = this.readAllData(StandardCharsets.UTF_8);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.readAllData must not return null");
        }
        return string;
    }

    @NotNull
    public byte[] readAllBytes() throws IOException {
        byte[] byArray = MiscUtil.readInputStreamToBytes(this.getDataSourceInputStream());
        if (byArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.readAllBytes must not return null");
        }
        return byArray;
    }

    @NotNull
    public String readAllData(@NotNull Charset charset) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/email/AttachmentResource.readAllData must not be null");
        }
        Preconditions.checkNonEmptyArgument(charset, "charset");
        String string = MiscUtil.readInputStreamToString(this.getDataSourceInputStream(), charset);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.readAllData must not return null");
        }
        return string;
    }

    @NotNull
    public DataSource getDataSource() {
        DataSource dataSource = this.dataSource;
        if (dataSource == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.getDataSource must not return null");
        }
        return dataSource;
    }

    @NotNull
    public InputStream getDataSourceInputStream() {
        InputStream inputStream;
        try {
            inputStream = this.dataSource.getInputStream();
        }
        catch (IOException e) {
            throw new AttachmentResourceException("Error getting input stream from attachment's data source", e);
        }
        if (inputStream == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.getDataSourceInputStream must not return null");
        }
        return inputStream;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentResource that = (AttachmentResource)o;
        return Objects.equals(this.name, that.name) && EqualsHelper.isEqualDataSource(this.dataSource, that.dataSource);
    }

    @NotNull
    public String toString() {
        String string = "AttachmentResource{\n\t\tname='" + this.name + '\'' + ",\n\t\tdataSource.name=" + this.dataSource.getName() + ",\n\t\tdataSource.getContentType=" + this.dataSource.getContentType() + "\n\t}";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/AttachmentResource.toString must not return null");
        }
        return string;
    }

    private static class AttachmentResourceException
    extends MailException {
        protected AttachmentResourceException(String message, Throwable cause) {
            if (message == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/email/AttachmentResource$AttachmentResourceException.<init> must not be null");
            }
            if (cause == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/email/AttachmentResource$AttachmentResourceException.<init> must not be null");
            }
            super(message, cause);
        }
    }
}

