/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport.socks5server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.simplejavamail.api.internal.authenticatedsockssupport.common.Socks5Bridge;
import org.simplejavamail.internal.authenticatedsockssupport.common.SocksException;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.SocksSession;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.io.SocketPipe;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.msg.CommandMessage;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.msg.CommandResponseMessage;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.msg.MethodSelectionMessage;
import org.simplejavamail.internal.authenticatedsockssupport.socks5server.msg.ServerReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5Handler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Socks5Handler.class);
    private static final Logger SOCKS5BRIDGE_LOGGER = LoggerFactory.getLogger((String)"socks5bridge");
    private static final byte[] METHOD_SELECTION_RESPONSE = new byte[]{5, 0};
    private static final int CONNECT_COMMAND = 1;
    public static final int VERSION = 5;
    private final SocksSession session;
    private final Socks5Bridge socks5Bridge;

    public Socks5Handler(SocksSession session, Socks5Bridge socks5Bridge) {
        this.session = session;
        this.socks5Bridge = socks5Bridge;
    }

    @Override
    public void run() {
        try {
            this.handle(this.session, this.socks5Bridge);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.session.close();
        }
    }

    private void handle(SocksSession session, Socks5Bridge socks5Bridge) throws IOException {
        if (MethodSelectionMessage.readVersion(session.getInputStream()) != 5) {
            throw new SocksException("Protocol error");
        }
        LOGGER.debug("SESSION[{}]", (Object)session.getId());
        session.write(METHOD_SELECTION_RESPONSE);
        CommandMessage commandMessage = new CommandMessage();
        commandMessage.read(session.getInputStream());
        if (commandMessage.hasSocksException()) {
            ServerReply serverReply = commandMessage.getSocksServerReplyException().getServerReply();
            session.write(CommandResponseMessage.getBytes(serverReply));
            LOGGER.debug("SESSION[{}] will close, because {}", (Object)session.getId(), (Object)serverReply);
            return;
        }
        if (commandMessage.getCommand() != 1) {
            throw new SocksException("Only CONNECT command is supported");
        }
        this.doConnect(session, commandMessage, socks5Bridge);
    }

    private void doConnect(SocksSession session, CommandMessage commandMessage, Socks5Bridge socks5Bridge) throws IOException {
        ServerReply reply;
        Socket socket = null;
        int bindPort = 0;
        InetAddress targetServerAddress = commandMessage.getInetAddress();
        int targetServerPort = commandMessage.getPort();
        InetAddress bindAddress = new InetSocketAddress(0).getAddress();
        try {
            socket = socks5Bridge.connect(String.valueOf(this.session.getId()), targetServerAddress, targetServerPort);
            bindAddress = socket.getLocalAddress();
            bindPort = socket.getLocalPort();
            reply = ServerReply.SUCCEEDED;
        }
        catch (IOException e) {
            reply = e.getMessage().equals("Connection refused") ? ServerReply.CONNECTION_REFUSED : (e.getMessage().equals("Operation timed out") ? ServerReply.TTL_EXPIRED : (e.getMessage().equals("Network is unreachable") ? ServerReply.NETWORK_UNREACHABLE : (e.getMessage().equals("Connection timed out") ? ServerReply.TTL_EXPIRED : ServerReply.GENERAL_SOCKS_SERVER_FAILURE)));
            InetSocketAddress remoteAddress = new InetSocketAddress(targetServerAddress, targetServerPort);
            if (e.getMessage().equals("Permission denied: connect")) {
                String msg = "Permission denied - unable to establish outbound connection to proxy. Perhaps blocked by a firewall?";
                LOGGER.info("connect {} [{}] exception: {}", new Object[]{session.getId(), remoteAddress, "Permission denied - unable to establish outbound connection to proxy. Perhaps blocked by a firewall?"});
                SOCKS5BRIDGE_LOGGER.error("connecting to {}: {}", (Object)remoteAddress, (Object)"Permission denied - unable to establish outbound connection to proxy. Perhaps blocked by a firewall?");
            }
            LOGGER.info("SESSION[{}] connect {} [{}] exception: {}", new Object[]{session.getId(), remoteAddress, reply, e.getMessage()});
        }
        session.write(CommandResponseMessage.getBytes(reply, bindAddress, bindPort));
        if (reply != ServerReply.SUCCEEDED) {
            session.close();
            return;
        }
        SocketPipe pipe = new SocketPipe(session.getSocket(), socket);
        pipe.setName("SESSION[" + session.getId() + "]");
        pipe.start();
        while (pipe.isRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                pipe.stop();
                session.close();
                LOGGER.info("SESSION[{}] closed from {}", (Object)session.getId(), (Object)session.getClientAddress());
            }
        }
    }
}

