/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.util.List;
import org.junit.Assert;

public class JoinTest {
    public static final Object[][] ROWS = new Object[][]{{1, "professor1", 3, "student3", "phone31"}, {1, "professor1", 3, "student3", "phone32"}, {1, "professor1", 4, "student4", "phone41"}, {2, "professor2", 4, "student4", "phone51"}, {2, "professor2", 4, "student4", "phone52"}, {3, "professor3", null, null, null}};

    public static void validateProfessors(List<? extends Professor<?>> professors) {
        Assert.assertEquals((String)"we get 3 professors from the resultset", (long)3L, (long)professors.size());
        Professor<?> professor1 = professors.get(0);
        JoinTest.assertPersonEquals(1, "professor1", professor1);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)professor1.getStudents().size());
        JoinTest.assertPersonEquals(3, "student3", (Person)professor1.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31", "phone32"}, (Object[])((Student)professor1.getStudents().get(0)).getPhones().toArray());
        JoinTest.assertPersonEquals(4, "student4", (Person)professor1.getStudents().get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"phone41"}, (Object[])((Student)professor1.getStudents().get(1)).getPhones().toArray());
        Professor<?> professor2 = professors.get(1);
        JoinTest.assertPersonEquals(2, "professor2", professor2);
        Assert.assertEquals((String)"has 1 student", (long)1L, (long)professor2.getStudents().size());
        JoinTest.assertPersonEquals(4, "student4", (Person)professor2.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone51", "phone52"}, (Object[])((Student)professor2.getStudents().get(0)).getPhones().toArray());
        Professor<?> professor3 = professors.get(2);
        JoinTest.assertPersonEquals(3, "professor3", professor3);
        Assert.assertNotNull(professor3.getStudents());
        Assert.assertTrue((String)"professor3 has no students", (boolean)professor3.getStudents().isEmpty());
    }

    public static void assertPersonEquals(int id, String name, Person person) {
        Assert.assertEquals((long)id, (long)person.getId());
        Assert.assertEquals((Object)name, (Object)person.getName());
    }

    public static <T extends Professor<?>> void validateProfessorMap(T professor0) {
        JoinTest.assertPersonEquals(1, "professor1", professor0);
        Assert.assertEquals((String)"has 2 students", (long)1L, (long)professor0.getStudents().size());
        JoinTest.assertPersonEquals(3, "student3", (Person)professor0.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31"}, (Object[])((Student)professor0.getStudents().get(0)).getPhones().toArray());
    }

    public static <T extends Professor<?>> void validateProfessorMapTo(T professor0) {
        JoinTest.assertPersonEquals(1, "professor1", professor0);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)professor0.getStudents().size());
        JoinTest.assertPersonEquals(3, "student3", (Person)professor0.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31"}, (Object[])((Student)professor0.getStudents().get(0)).getPhones().toArray());
        JoinTest.assertPersonEquals(4, "student4", (Person)professor0.getStudents().get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"phone41"}, (Object[])((Student)professor0.getStudents().get(1)).getPhones().toArray());
    }

    private <T extends Professor<?>> void validateProfessor(T professor) {
        JoinTest.assertPersonEquals(1, "professor1", professor);
    }

    public static class ProfessorC
    implements Professor<StudentC> {
        private final int id;
        private final String name;
        private final List<StudentC> students;

        public ProfessorC(int id, String name, List<StudentC> students) {
            this.id = id;
            this.name = name;
            this.students = students;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<StudentC> getStudents() {
            return this.students;
        }
    }

    public static class StudentC
    implements Student {
        private final int id;
        private final String name;
        private final List<String> phones;

        public StudentC(int id, String name, List<String> phones) {
            this.id = id;
            this.name = name;
            this.phones = phones;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getPhones() {
            return this.phones;
        }
    }

    public static class ProfessorGS
    implements Professor<StudentGS> {
        private int id;
        private String name;
        private List<StudentGS> students;

        @Override
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public List<StudentGS> getStudents() {
            return this.students;
        }

        public void setStudents(List<StudentGS> students) {
            this.students = students;
        }
    }

    public static class StudentGS
    implements Student {
        private int id;
        private String name;
        private List<String> phones;

        @Override
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public List<String> getPhones() {
            return this.phones;
        }

        public void setPhones(List<String> phones) {
            this.phones = phones;
        }
    }

    public static class ProfessorField
    implements Professor<StudentField> {
        public int id;
        public String name;
        public List<StudentField> students;

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<StudentField> getStudents() {
            return this.students;
        }
    }

    public static class StudentField
    implements Student {
        public int id;
        public String name;
        public List<String> phones;

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getPhones() {
            return this.phones;
        }
    }

    public static interface Professor<T extends Student>
    extends Person {
        public List<T> getStudents();
    }

    public static interface Student
    extends Person {
        public List<String> getPhones();
    }

    public static interface Person {
        public int getId();

        public String getName();
    }
}

