/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.converter.ContextFactory;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.DefaultContextFactoryBuilder;
import org.simpleflatmapper.converter.EmptyContextFactory;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcTypeHelper;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.named.NamedParameter;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.jdbc.spring.ArrayPlaceHolderValueGetterSource;
import org.simpleflatmapper.jdbc.spring.MapPlaceHolderValueGetterSource;
import org.simpleflatmapper.jdbc.spring.PlaceHolderValueGetter;
import org.simpleflatmapper.jdbc.spring.PlaceHolderValueGetterSource;
import org.simpleflatmapper.jdbc.spring.SqlParameterSourceFactory;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyWithGetter;
import org.simpleflatmapper.map.fieldmapper.FieldMapperGetterWithConverter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterAdapter;
import org.simpleflatmapper.map.getter.NullContextualGetter;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.property.ConstantValueProperty;
import org.simpleflatmapper.map.property.ConverterProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;
import org.springframework.jdbc.core.StatementCreatorUtils;

public final class SqlParameterSourceBuilder<T> {
    private final PropertyMappingsBuilder<T, JdbcColumnKey> builder;
    private final MapperConfig<JdbcColumnKey, ?> mapperConfig;
    private final ReflectionService reflectionService;
    private int index = 1;
    private final List<PlaceHolderValueGetter> parameters = new ArrayList<PlaceHolderValueGetter>();

    public SqlParameterSourceBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, ?> mapperConfig) {
        this.mapperConfig = mapperConfig;
        this.reflectionService = classMeta.getReflectionService();
        this.builder = PropertyMappingsBuilder.of(classMeta, mapperConfig, (PropertyMappingsBuilder.PropertyPredicateFactory)new PropertyMappingsBuilder.PropertyPredicateFactory<JdbcColumnKey>(){

            public PropertyFinder.PropertyFilter predicate(JdbcColumnKey jdbcColumnKey, Object[] objects, List<PropertyMappingsBuilder.AccessorNotFound> accessorNotFounds) {
                return new PropertyFinder.PropertyFilter((Predicate)PropertyWithGetter.INSTANCE);
            }
        });
    }

    public SqlParameterSourceBuilder<T> add(String column) {
        return this.add(new JdbcColumnKey(column, this.index++), (FieldMapperColumnDefinition<JdbcColumnKey>)FieldMapperColumnDefinition.identity());
    }

    public SqlParameterSourceBuilder<T> add(JdbcColumnKey key, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        PropertyMapping propertyMapping;
        FieldMapperColumnDefinition composedDefinition = (FieldMapperColumnDefinition)columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition((FieldKey)key));
        JdbcColumnKey mappedColumnKey = (JdbcColumnKey)composedDefinition.rename((FieldKey)key);
        if (composedDefinition.has(ConstantValueProperty.class)) {
            ConstantValueProperty staticValueProperty = (ConstantValueProperty)composedDefinition.lookFor(ConstantValueProperty.class);
            ObjectPropertyMeta meta = new ObjectPropertyMeta(key.getName(), this.builder.getClassMeta().getType(), this.reflectionService, staticValueProperty.getType(), ScoredGetter.of((Getter)new ConstantGetter(staticValueProperty.getValue()), (int)1), null, null);
            propertyMapping = this.builder.addProperty((FieldKey)key, columnDefinition, (PropertyMeta)meta);
        } else {
            propertyMapping = this.builder.addProperty((FieldKey)mappedColumnKey, (ColumnDefinition)composedDefinition);
        }
        this.parameters.add(this.build(key, propertyMapping));
        return this;
    }

    private <P> PlaceHolderValueGetter<T> build(JdbcColumnKey key, PropertyMapping<T, P, JdbcColumnKey> pm) {
        if (pm != null) {
            ContextualConverter converter;
            int parameterType = SqlParameterSourceBuilder.getParameterType(pm);
            ContextualGetter getter = ContextualGetterAdapter.of((Getter)pm.getPropertyMeta().getGetter());
            DefaultContextFactoryBuilder contextFactoryBuilder = new DefaultContextFactoryBuilder();
            Type propertyType = pm.getPropertyMeta().getPropertyType();
            Class sqlType = JdbcTypeHelper.toJavaType((int)parameterType, (Type)propertyType);
            boolean findConverter = false;
            for (ConverterProperty cp : (ConverterProperty[])pm.getColumnDefinition().lookForAll(ConverterProperty.class)) {
                if (!TypeHelper.isAssignable((Type)cp.inType, (Type)propertyType)) continue;
                getter = new FieldMapperGetterWithConverter(cp.function, getter);
                findConverter = true;
                break;
            }
            if (!findConverter && !TypeHelper.isAssignable((Class)sqlType, (Type)propertyType) && (converter = ConverterService.getInstance().findConverter(propertyType, (Type)sqlType, (ContextFactoryBuilder)contextFactoryBuilder, new Object[0])) != null) {
                getter = new FieldMapperGetterWithConverter(converter, getter);
            }
            return new PlaceHolderValueGetter(((JdbcColumnKey)pm.getColumnKey()).getOrginalName(), parameterType, null, getter, contextFactoryBuilder.build());
        }
        return new PlaceHolderValueGetter(key.getOrginalName(), key.getSqlType(null), null, NullContextualGetter.getter(), (ContextFactory)EmptyContextFactory.INSTANCE);
    }

    public SqlParameterSourceFactory<T> buildFactory(String sql) {
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        for (int i = 0; i < namedSqlQuery.getParametersSize(); ++i) {
            NamedParameter parameter = namedSqlQuery.getParameter(i);
            this.add(parameter.getName());
        }
        return this.buildFactory();
    }

    public PlaceHolderValueGetterSource<T> buildSource() {
        PlaceHolderValueGetter[] parameters = this.parameters.toArray(new PlaceHolderValueGetter[0]);
        return parameters.length < 10 ? new ArrayPlaceHolderValueGetterSource(parameters) : new MapPlaceHolderValueGetterSource(parameters);
    }

    private static int getParameterType(PropertyMapping<?, ?, JdbcColumnKey> pm) {
        Class propertyType = TypeHelper.toClass((Type)pm.getPropertyMeta().getPropertyType());
        if (pm.getColumnDefinition().has(SqlTypeColumnProperty.class)) {
            return ((SqlTypeColumnProperty)pm.getColumnDefinition().lookFor(SqlTypeColumnProperty.class)).getSqlType();
        }
        int t = StatementCreatorUtils.javaTypeToSqlParameterType((Class)propertyType);
        if (t == Integer.MIN_VALUE) {
            if (propertyType.equals(ZonedDateTime.class) || propertyType.equals(OffsetDateTime.class)) {
                return 2014;
            }
            if (propertyType.equals(Instant.class) || propertyType.equals(LocalDateTime.class)) {
                return 93;
            }
            if (propertyType.equals(LocalDate.class)) {
                return 91;
            }
            if (propertyType.equals(LocalTime.class)) {
                return 92;
            }
            return -99999;
        }
        return t;
    }

    public SqlParameterSourceFactory<T> buildFactory() {
        return new SqlParameterSourceFactory<T>(this.buildSource());
    }
}

