/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.util.concurrent.atomic.AtomicReference;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.spring.ArrayPlaceHolderValueGetterSource;
import org.simpleflatmapper.jdbc.spring.PlaceHolderValueGetter;
import org.simpleflatmapper.jdbc.spring.PlaceHolderValueGetterSource;
import org.simpleflatmapper.jdbc.spring.SqlParameterSourceBuilder;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.reflect.meta.ClassMeta;

public class DynamicPlaceHolderValueGetterSource<T>
implements PlaceHolderValueGetterSource<T> {
    private final AtomicReference<PlaceHolderValueGetterSource<T>> delegate;
    private final ClassMeta<T> classMeta;
    private final MapperConfig<JdbcColumnKey> mapperConfig;

    public DynamicPlaceHolderValueGetterSource(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey> mapperConfig) {
        this.classMeta = classMeta;
        this.mapperConfig = mapperConfig;
        this.delegate = new AtomicReference(new ArrayPlaceHolderValueGetterSource(new PlaceHolderValueGetter[0]));
    }

    @Override
    public PlaceHolderValueGetter<T> getPlaceHolderValueGetter(String column) {
        PlaceHolderValueGetterSource<T> nssp;
        PlaceHolderValueGetterSource<T> ssp;
        do {
            PlaceHolderValueGetter<T> parameter;
            if ((parameter = (ssp = this.delegate.get()).getPlaceHolderValueGetter(column)) == null) continue;
            return parameter;
        } while (!this.delegate.compareAndSet(ssp, nssp = this.addColumn(ssp, column)));
        return nssp.getPlaceHolderValueGetter(column);
    }

    @Override
    public Iterable<PlaceHolderValueGetter<T>> getParameters() {
        return this.delegate.get().getParameters();
    }

    private PlaceHolderValueGetterSource<T> addColumn(PlaceHolderValueGetterSource<T> ssp, String column) {
        SqlParameterSourceBuilder<T> builder = new SqlParameterSourceBuilder<T>(this.classMeta, this.mapperConfig);
        for (PlaceHolderValueGetter<T> ph : ssp.getParameters()) {
            builder.add(ph.getColumn());
        }
        builder.add(column);
        return builder.buildSource();
    }
}

