/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

public final class ResultSetExtractorImpl<T>
implements ResultSetExtractor<List<T>> {
    private final JdbcMapper<T> mapper;

    public ResultSetExtractorImpl(JdbcMapper<T> mapper) {
        this.mapper = mapper;
    }

    public List<T> extractData(ResultSet rs) throws SQLException, DataAccessException {
        return ((ListCollector)this.mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
    }

    public <H extends CheckedConsumer<T>> ResultSetExtractor<H> newResultSetExtractor(final H handler) {
        return new ResultSetExtractor<H>(){

            public H extractData(ResultSet rs) throws SQLException, DataAccessException {
                return ResultSetExtractorImpl.this.mapper.forEach(rs, handler);
            }
        };
    }
}

