/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.spring.ArrayPlaceHolderValueGetterSource;
import org.sfm.jdbc.spring.MapPlaceHolderValueGetterSource;
import org.sfm.jdbc.spring.PlaceHolderValueGetter;
import org.sfm.jdbc.spring.PlaceHolderValueGetterSource;
import org.sfm.jdbc.spring.SqlParameterSourceFactory;
import org.sfm.map.FieldKey;
import org.sfm.map.MapperConfig;
import org.sfm.map.PropertyWithGetter;
import org.sfm.map.column.ConstantValueProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.mapper.PropertyMappingsBuilder;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.ScoredGetter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.ConstantGetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ObjectPropertyMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;
import org.sfm.utils.Predicate;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;

public final class SqlParameterSourceBuilder<T> {
    private final PropertyMappingsBuilder<T, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> builder;
    private final MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> mapperConfig;
    private final ReflectionService reflectionService;
    private int index = 1;
    private static final Field paramNamesField;

    public SqlParameterSourceBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> mapperConfig) {
        this.mapperConfig = mapperConfig;
        this.reflectionService = classMeta.getReflectionService();
        this.builder = new PropertyMappingsBuilder(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler(), (Predicate)new PropertyWithGetter());
    }

    public SqlParameterSourceBuilder<T> add(String column) {
        return this.add(new JdbcColumnKey(column, this.index++), (FieldMapperColumnDefinition<JdbcColumnKey>)FieldMapperColumnDefinition.identity());
    }

    public SqlParameterSourceBuilder<T> add(JdbcColumnKey key, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        FieldMapperColumnDefinition composedDefinition = (FieldMapperColumnDefinition)columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition((FieldKey)key));
        JdbcColumnKey mappedColumnKey = (JdbcColumnKey)composedDefinition.rename((FieldKey)key);
        if (composedDefinition.has(ConstantValueProperty.class)) {
            ConstantValueProperty staticValueProperty = (ConstantValueProperty)composedDefinition.lookFor(ConstantValueProperty.class);
            ObjectPropertyMeta meta = new ObjectPropertyMeta(key.getName(), this.reflectionService, staticValueProperty.getType(), ScoredGetter.of((Getter)new ConstantGetter(staticValueProperty.getValue()), (int)1), null);
            this.builder.addProperty((FieldKey)key, columnDefinition, (PropertyMeta)meta);
        } else {
            this.builder.addProperty((FieldKey)mappedColumnKey, (ColumnDefinition)composedDefinition);
        }
        return this;
    }

    public SqlParameterSourceFactory<T> buildFactory(ParsedSql parsedSql) {
        if (paramNamesField == null) {
            throw new IllegalArgumentException("Unable to gain access to paramNames field in parsedSql");
        }
        try {
            List names = (List)paramNamesField.get(parsedSql);
            for (String name : names) {
                this.add(name);
            }
        }
        catch (IllegalAccessException e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        return this.buildFactory();
    }

    public PlaceHolderValueGetterSource<T> buildSource() {
        final PlaceHolderValueGetter[] parameters = new PlaceHolderValueGetter[this.builder.size()];
        this.builder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>>>(){
            int i = 0;

            public void handle(PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                PlaceHolderValueGetter parameter;
                parameters[this.i] = parameter = new PlaceHolderValueGetter(((JdbcColumnKey)pm.getColumnKey()).getOrginalName(), StatementCreatorUtils.javaTypeToSqlParameterType((Class)TypeHelper.toClass((Type)pm.getPropertyMeta().getPropertyType())), null, pm.getPropertyMeta().getGetter());
                ++this.i;
            }
        });
        return parameters.length > 10 ? new ArrayPlaceHolderValueGetterSource(parameters) : new MapPlaceHolderValueGetterSource(parameters);
    }

    public SqlParameterSourceFactory<T> buildFactory() {
        return new SqlParameterSourceFactory<T>(this.buildSource());
    }

    static {
        Field f = null;
        try {
            f = ParsedSql.class.getDeclaredField("parameterNames");
            f.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        paramNamesField = f;
    }
}

