/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.AbstractIndexPropertyFinder;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ConstructorPropertyMeta;
import org.sfm.reflect.meta.IndexedColumn;
import org.sfm.reflect.meta.IndexedElement;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.reflect.meta.TupleClassMeta;

public class TuplePropertyFinder<T>
extends AbstractIndexPropertyFinder<T> {
    public TuplePropertyFinder(TupleClassMeta<T> tupleClassMeta) {
        super(tupleClassMeta);
        for (int i = 0; i < tupleClassMeta.getTupleSize(); ++i) {
            this.elements.add(this.newIndexedElement(tupleClassMeta, i));
        }
    }

    private <E> IndexedElement<T, E> newIndexedElement(TupleClassMeta<T> tupleClassMeta, int i) {
        ConstructorPropertyMeta<T, E> prop = this.newConstructorPropertyMeta(tupleClassMeta, i);
        ClassMeta classMeta = tupleClassMeta.getReflectionService().getClassMeta(prop.getPropertyType());
        return new IndexedElement<T, E>(prop, classMeta);
    }

    private <E> ConstructorPropertyMeta<T, E> newConstructorPropertyMeta(TupleClassMeta<T> tupleClassMeta, int i) {
        Class tClass = TypeHelper.toClass(tupleClassMeta.getType());
        Parameter parameter = this.getEligibleInstantiatorDefinitions().get(0).getParameters()[i];
        return new ConstructorPropertyMeta(parameter.getName(), tupleClassMeta.getReflectionService(), parameter, tClass);
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() < this.elements.size();
    }

    @Override
    protected IndexedElement<T, ?> getIndexedElement(IndexedColumn indexedColumn) {
        return (IndexedElement)this.elements.get(indexedColumn.getIndexValue());
    }

    @Override
    protected IndexedColumn extrapolateIndex(PropertyNameMatcher propertyNameMatcher) {
        for (int i = 0; i < this.elements.size(); ++i) {
            PropertyFinder pf;
            PropertyMeta property;
            IndexedElement element = (IndexedElement)this.elements.get(i);
            if (element.getElementClassMeta() == null || (property = (pf = element.getPropertyFinder()).findProperty(propertyNameMatcher)) == null || element.hasProperty(property)) continue;
            return new IndexedColumn(i, propertyNameMatcher);
        }
        return null;
    }
}

