/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DirectClassMeta;
import org.sfm.reflect.meta.MapElementPropertyMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.reflect.meta.SubPropertyMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.conv.Converter;

public class MapPropertyFinder<T extends Map<K, V>, K, V>
implements PropertyFinder<T> {
    private final ClassMeta<V> valueMetaData;
    private final ClassMeta<T> mapMeta;
    private final Converter<CharSequence, K> keyConverter;
    private final Map<PropertyNameMatcher, PropertyFinder<V>> finders = new HashMap<PropertyNameMatcher, PropertyFinder<V>>();

    public MapPropertyFinder(ClassMeta<T> mapMeta, ClassMeta<V> valueMetaData, Converter<CharSequence, K> keyConverter) {
        this.mapMeta = mapMeta;
        this.valueMetaData = valueMetaData;
        this.keyConverter = keyConverter;
    }

    @Override
    public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        try {
            for (Tuple2<PropertyNameMatcher, PropertyNameMatcher> keyValue : propertyNameMatcher.keyValuePairs()) {
                PropertyMeta propertyMeta;
                PropertyNameMatcher keyMatcher = keyValue.first();
                PropertyNameMatcher valueMatcher = keyValue.second();
                PropertyFinder<V> propertyFinder = this.finders.get(keyMatcher);
                if (propertyFinder == null) {
                    propertyFinder = this.valueMetaData.newPropertyFinder();
                }
                if ((propertyMeta = propertyFinder.findProperty(valueMatcher)) == null) continue;
                this.finders.put(keyMatcher, propertyFinder);
                if (propertyMeta instanceof DirectClassMeta.DirectPropertyMeta) {
                    return this.newKeyProperty(keyMatcher);
                }
                return this.newSubPropertyMeta(keyMatcher, propertyMeta);
            }
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
        return null;
    }

    private <E> PropertyMeta<T, E> newSubPropertyMeta(PropertyNameMatcher keyMatcher, PropertyMeta<V, ?> propertyMeta) throws Exception {
        PropertyMeta<T, E> keyProperty = this.newKeyProperty(keyMatcher);
        SubPropertyMeta subPropertyMeta = new SubPropertyMeta(this.valueMetaData.getReflectionService(), keyProperty, propertyMeta);
        return subPropertyMeta;
    }

    private <E> PropertyMeta<T, E> newKeyProperty(PropertyNameMatcher propertyNameMatcher) throws Exception {
        return new MapElementPropertyMeta(propertyNameMatcher, this.valueMetaData.getReflectionService(), this.valueMetaData, this.keyConverter.convert(propertyNameMatcher.toString()));
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.mapMeta.getInstantiatorDefinitions();
    }
}

